#-*- coding: utf-8 -*-

import sys, urllib, urllib2, re, cookielib, os, json, datetime, ast
import xbmc, xbmcplugin, xbmcgui, xbmcaddon, xbmcvfs

sysarg=str(sys.argv[1])
ADDON_ID='plugin.audio.jpplay'
addon = xbmcaddon.Addon(id=ADDON_ID)
home=xbmc.translatePath(addon.getAddonInfo('path').decode('utf-8'))

headers = {'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11',
       'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
       'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.3',
       'Accept-Encoding': 'none',
       'Accept-Language': 'en-US,en;q=0.8',
       'Connection': 'keep-alive'}
   
viet= ['ạ', 'ậ', 'ả', 'á', 'à', 'ư']   
   
username=xbmcaddon.Addon().getSetting('username')
password=xbmcaddon.Addon().getSetting('password')
   
   
   
def parseParameters(inputString=sys.argv[2]):
    """Parses a parameter string starting at the first ? found in inputString
    
    Argument:
    inputString: the string to be parsed, sys.argv[2] by default
    
    Returns a dictionary with parameter names as keys and parameter values as values
    """
    
    
    parameters = {}
    p1 = inputString.find('?')
    if p1 >= 0:
        splitParameters = inputString[p1 + 1:].split('&')
        for nameValuePair in splitParameters:
            try:
                if (len(nameValuePair) > 0):
                    pair = nameValuePair.split('=')
                    key = pair[0]
                    value = urllib.unquote(urllib.unquote_plus(pair[1])).decode('utf-8')
                    parameters[key] = value
            except:
                pass
    return parameters

def extractAll(text, startText, endText):
    """
    Extract all occurences of a string within text that start with startText and end with endText
    
    Parameters:
    text: the text to be parsed
    startText: the starting tokem
    endText: the ending token
    
    Returns an array containing all occurences found, with tabs and newlines removed and leading whitespace removed
    """
    result = []
    start = 0
    pos = text.find(startText, start)
    while pos != -1:
        start = pos + startText.__len__()
        end = text.find(endText, start)
        result.append(text[start:end].replace('\n', '').replace('\t', '').lstrip())
        pos = text.find(startText, end)
    return result

def extract(text, startText, endText):
    """
    Extract the first occurence of a string within text that start with startText and end with endText
    
    Parameters:
    text: the text to be parsed
    startText: the starting tokem
    endText: the ending token
    
    Returns the string found between startText and endText, or None if the startText or endText is not found
    """
    start = text.find(startText, 0)
    if start != -1:
        start = start + startText.__len__()
        end = text.find(endText, start + 1)
        if end != -1:
            return text[start:end]
    return None      
    

def getURL(url, header=headers):
    try:
        req = urllib2.Request(url.encode('utf-8'), headers=header)
            
        response = urllib2.urlopen(req)
        
        if response and response.getcode() == 200:
            if response.info().get('Content-Encoding') == 'gzip':
                buf = StringIO.StringIO( response.read())
                gzip_f = gzip.GzipFile(fileobj=buf)
                content = gzip_f.read()
            else:
                content = response.read()
            content = content.decode('utf-8', 'ignore')
            return content
        else:
            xbmc.log('Error Loading URL : '+str(response.getcode()), xbmc.LOGERROR)
    except urllib2.HTTPError as err:
        logError('Error Loading URL : '+url.encode("utf-8"))
        logError(str(err))
    except urllib2.URLError as err:
        logError('Error Loading URL : '+url.encode("utf-8"))
        logError(str(err))
    except socket.timeout as err:
        logError('Error Loading URL : '+url.encode("utf-8"))
        logError(str(err))
    
    return False
    
def addMenuItems(details, show=True, mode=0):
    changed=False
    counter=1
    for detail in details:
        if any(ext in detail['title'].encode('utf-8') for ext in viet):
            detail['title']=translate(detail['title'].encode("utf-8"))

    
        try:
            u=sys.argv[0]+"?url="+detail['url']+"&mode="+str(detail['mode'])+"&name="+urllib.quote_plus(detail['title'].encode("utf-8"))+"&icon="+detail['icon']+"&fanart="+detail['fanart']
            liz=xbmcgui.ListItem(unescape(detail['title']).encode("utf-8"), iconImage=detail['icon'], thumbnailImage=detail['icon'])
        except:
            u=sys.argv[0]+"?url="+detail['url']+"&mode="+str(detail['mode'])+"&name="+urllib.quote_plus(detail['title']).decode("utf-8")+"&icon="+detail['icon']+"&fanart="+detail['fanart']
            liz=xbmcgui.ListItem(unescape(detail['title']).decode("utf-8"), iconImage=detail['icon'], thumbnailImage=detail['icon'])
        
        try:
            u=u+"&genre="+detail['genre']
        except:
            pass
        try:
            liz.setProperty("Fanart_Image", detail['fanart'])
            u=u+"&fanart="+detail['fanart']
        except:
            pass
        try:
            liz.setProperty("Landscape_Image", detail['fanart'])
            u=u+"&landscape="+detail['fanart']
        except:
            pass
            
        try:
            liz.setInfo("Artist", detail['artist'])
        except:
            pass
        try:
            extras=ast.literal_eval(str(detail["extras"]))
            for key, value in extras.iteritems():
                extras[key]=unescape(value)
            liz.setInfo("music", extras)
            extras={"extras":detail["extras"]}
            u=u+"&"+urllib.urlencode(extras)
        except Exception as e:
            logError(str(e))
            
        if detail['isFolder']:
            ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=True)
        else:
            liz.setProperty('IsPlayable', 'true')
            ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=False)
    
    if mode==0:
        #54
        xbmc.executebuiltin('Container.SetViewMode(%d)' % int(xbmcaddon.Addon().getSetting('default')))
    else:
        #50
        xbmc.executebuiltin('Container.SetViewMode(%d)' % int(xbmcaddon.Addon().getSetting('albums')))
    
    if show:
        xbmcplugin.endOfDirectory(int(sysarg))
        
def alert(alertText):
    dialog = xbmcgui.Dialog()
    ret = dialog.ok("J*PLAY", alertText)
    
def select(list):
    dialog = xbmcgui.Dialog()
    ret = dialog.select("J*PLAY", list)
    return ret
        
def notify(addonId, message, reportError=False, timeShown=5000):
    """Displays a notification to the user
    
    Parameters:
    addonId: the current addon id
    message: the message to be shown
    timeShown: the length of time for which the notification will be shown, in milliseconds, 5 seconds by default
    """
    addon = xbmcaddon.Addon(addonId)
    xbmc.executebuiltin('Notification(%s, %s, %d, %s)' % (addon.getAddonInfo('name'), message, timeShown, addon.getAddonInfo('icon')))
    if reportError:
        logError(message)

def logError(error):
    try:
        xbmc.log("JPPLAY Error - "+str(error.encode("utf-8")), xbmc.LOGERROR)
    except:
        xbmc.log("JPPLAY Error - "+str(error), xbmc.LOGERROR)
    
def searchDialog(searchText="Please enter search text") :    
    keyb=xbmc.Keyboard('', searchText)
    keyb.doModal()
    searchText=''
    
    if (keyb.isConfirmed()) :
        searchText = keyb.getText()
    if searchText!='':
        return searchText
    return False

def progressStart(title, status):
    pDialog = xbmcgui.DialogProgress()
    pDialog.create(title, status)
    xbmc.executebuiltin( "Dialog.Close(busydialog)" )
    progressUpdate(pDialog, 1, status)
    return pDialog

def progressStop(pDialog):
    pDialog.close
    
def progressCancelled(pDialog):
    if pDialog.iscanceled():
        pDialog.close
        return True
    return False

def progressUpdate(pDialog, progress, status, fanart):
    pDialog.update(int(progress), status)

def playMedia(title, thumbnail, link, extras, fanart) :
    extras=ast.literal_eval(extras)
    li = xbmcgui.ListItem(label=unescape(title), iconImage=thumbnail, thumbnailImage=thumbnail, path=link)
    li.setLabel2(unescape(title))
    li.setProperty("Fanart_Image", fanart)
    li.setProperty("Landscape_Image", fanart)
    xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, li)
    
    
# plugin specific code
def loadAlbum(params):
    # login for hidden songs
    try:
        cj2 = cookielib.CookieJar()
        opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj2))
        
        login_data = urllib.urlencode({'username_log' : username, 'password_log' : password})
        resp=opener.open('http://www.jpsync.com/login.php', login_data)
        
        items=[]
        page=opener.open(params['url'].encode('utf-8'))
        page=page.read()
        
        playlist=extract(page, "playlist: ", "stretching: 'fill',")
        playlist=playlist.replace("\t", "").replace("\r", "").replace("\n", "").replace(",],", "]")
        playlist=json.loads(playlist)
        
        try:
            cover="http://www.jpsync.com/"+extract(page, '<img class="img_detail album_detail" src="', '"')
        except:
            try:
                cover="http://www.jpsync.com/"+extract(extract(page, '<div class="avatar-singer">', '</div>'), '<img src="', '"')
            except:
                cover=os.path.join(home, '', 'fanart.jpg')
        counter=1
        for track in playlist:
            items.append({
                    "title": track['media_title'],
                    "url": track['sources'][0]['file'], 
                    "mode":100, 
                    "poster":cover,
                    "icon":cover, 
                    "fanart":"http://www.jpsync.com/"+track['image'],
                    "type":"music", 
                    "plot": "",
                    "extras": {"title": track['media_title'], "artist" : track['media_desc'].replace("=", " "), "album": params['name'], "tracknumber": str(counter)},
                    "isFolder":False
                })
            counter=counter+1
        addMenuItems(items)
    except Exception as e:
        if not username or not password:
            alert("You need a JPSync account to listen to this.\nSign up for your FREE account at http://jpsync.com and then enter your account details into the settings of this addon.")
        else:
            logError(str(e))
            notify(ADDON_ID, "Unable to play back song", True)
    
def loadAlbums(params):
    items=[]
    opener = urllib2.build_opener()
    #logError(params['url'])
    try:
        data = urllib.urlencode(ast.literal_eval(params['extras']))
        resp=opener.open(params['url'], data)
        data = ast.literal_eval(params['extras'])
        page=resp.read().decode("utf-8", "ignore")
        logError(page)
    except:
        page=getURL(params['url'])
    
    
    
    #page=getURL(params['url'])
    if "list-album" in page:
        albums=extractAll(page, '<li class="list-album">', '</li>')
    else:
        content=extract(page, '<ul class="list_playlist">', "</ul>")
        albums=extractAll(content, '<li class="thumb-hover ">', '</li>')
    
    
    for album in albums:
        #logError(album)
        try:
            if "ellipsis" in album:
                title=extract(album, 'class="name-album b ellipsis"> ', '<')
                if "icon-login" in album and (not username or not password):
                    title="[COLOR red]"+title+"[/COLOR]"
                artist=extract(album, 'class="ellipsis"> ', "<").strip() 
                url="http://www.jpsync.com/"+extract(extract(album, '<div class="name">', 'class="name-album'), 'href="', '"')
                img="http://www.jpsync.com/"+extract(album, '<img src="', '"')
            else:
                title=extract(extract(album, '<h3 class="name over-text white">', '</h3>'), 'title="', '"')
                if "icon-login" in album and (not username or not password):
                    title="[COLOR red]"+title+"[/COLOR]"
                artist=extract(extract(album, 'class="singer"', '/a>'), ">", "<").strip() 
                url="http://www.jpsync.com/"+extract(album, '<a href="', '"><img')
                img="http://www.jpsync.com/"+extract(album, '<img src="', '"')
            items.append({
                "title": title,
                "url": url, 
                "mode":3, 
                "poster":img,
                "icon":img, 
                "fanart":os.path.join(home, '', 'fanart.jpg'),
                "artist": artist,
                "type":"music", 
                "plot": "",
                "isFolder":True
            })
        except:
            pass
    if "pager" in page or len(albums)==25:
        #try:
        #<a class="" href="javascript:void(0);" onclick="get_album_of_kind('id', 'all', '2', '25');">2</a>
        try:
            next=extractAll(page, 'javascript:void(0);" onclick="get_album_of_kind(', ');"')
            if not next:
                page=extract(page, '<div id="pages-category">', '</div>')
                next=extractAll(page, 'javascript:void(0);" onclick="get_album_of_kind_new(', ');"')
        except:
            pass
        if next:
            next=next[0].replace("'", "").split(",")
            next={"order":data['order'], "cat_link_slug":data['cat_link_slug'], "pages":str(int(data['pages'])+1), "num1pages":"25"}
            items.append({
                    "title": "Next >",
                    "url": "http://www.jpsync.com/process/get_album_of_kind_new.php", 
                    "mode":2, 
                    "poster":os.path.join(home, 'resources/media', 'next.png'),
                    "icon":os.path.join(home, 'resources/media', 'next.png'),
                    "fanart":os.path.join(home, '', 'fanart.jpg'),
                    "type":"music", 
                    "plot": "",
                    "extras": next,
                    "isFolder":True
                })
        #except Exception as e:
        #    logError("Error adding next button "+str(e))
    addMenuItems(items, mode=1)
    
def searchArtists(params):
    items=[]
    term=searchDialog("Enter the Artist you wish to search for.")
    query={"q": term, "type": "singer"}
    page=getURL("http://www.jpsync.com/search.php?"+urllib.urlencode(query))
    #artists=extract(page, '<ul class="wap-artist-cat">', '</ul>')
    
    artists=extractAll(page, '<li class="sitem">', '</li>')
    
    for artist in artists:
        #try:
        title=extract(extract(artist, '<a href', '>'), 'title="', '"')
        url="http://www.jpsync.com/"+extract(artist, '<a href="', '" title="').replace("search.html", "album.html")
        img="http://www.jpsync.com/"+extract(artist, '<img src="', '"')
        items.append({
            "title": title,
            "url": url, 
            "mode":2, 
            "poster":img,
            "icon":img, 
            "fanart":os.path.join(home, '', 'fanart.jpg'),
            "type":"music", 
            "plot": "",
            "isFolder":True
        })
        # except:
         #   pass
    addMenuItems(items)

def searchSongs(params):
    items=[]
    term=searchDialog("Enter the Song you wish to search for.")
    query={"q": term, "type": "bai-hat"}
    page=getURL("http://www.jpsync.com/search.php?"+urllib.urlencode(query))
    artists=extract(page, '<div class="box song_list_items">', '<!--sidebar right-->')
    
    artists=extractAll(artists, '<li style="height: inherit;">', '</span>')
    
    for artist in artists:
        try:
            title=extract(artist, 'class="name" title="', '"')
            url="http://www.jpsync.com/"+extract(artist, '<h3 class="over-text"><a href="', '"')
            img="http://www.jpsync.com/images/website/singer-default.jpg"
            items.append({
                "title": title,
                "url": url, 
                "mode":3, 
                "poster":img,
                "icon":img, 
                "fanart":os.path.join(home, '', 'fanart.jpg'),
                "type":"music", 
                "plot": "",
                "isFolder":True
            })
        except:
            pass
    addMenuItems(items)

def searchAlbums(params):
    term=searchDialog("Enter the Artist you wish to search for.")
    query={"q": term, "type": "album"}
    params['url']="http://www.jpsync.com/search.php?"+urllib.urlencode(query)
    loadAlbums(params)
    
def artistByLetter(params):
    items=[]
    
    content=getURL(params['url'])
    pages=extract(content, '<ul class="pager"', '</ul>')
    pages=extractAll(pages, 'href="', '"')
    count=1
    
    for page in pages:
        if count>1:
            content=getURL("http://www.jpsync.com/"+page)
        
        artists=extract(content, '<ul class="list_playlist">', '</ul>')
        artists=extractAll(artists, '<li', '</li>')
        for artist in artists:
            title=extract(artist, 'alt="', '"')
            url="http://www.jpsync.com/"+extract(artist, 'href="', '"').replace(".html", "/album.html")
            img="http://www.jpsync.com/"+extract(artist, 'src="', '"')
            
            items.append({
                "title": title.lstrip(),
                "url": url, 
                "mode":2, 
                "poster":img,
                "icon":img, 
                "fanart":os.path.join(home, '', 'fanart.jpg'),
                "type":"music", 
                "plot": "",
                "isFolder":True
            })
            count=count+1
            
    items=sorted(items, key=lambda k: k['title'].lower(), reverse=False)    
    addMenuItems(items)

def topAlbums(params):
    items=[]
    
    page=getURL(params['url'])
    albums=extract(page, '<ul class="bxh_song_list bxh_list siz_w">', '<!--sidebar right-->')
    albums=extractAll(albums, '<span class="number ', '<i class="icon icon_share">')
    
    for album in albums:
        try:
            title=extract(extract(album, '<h3 class="over-text">', '</h3>'), '">', '</a>')
            url="http://www.jpsync.com/"+extract(extract(album, '<h3 class="over-text">', '</h3>'), '<a href="', '">')
            img="http://www.jpsync.com/"+extract(album, '<img class="thumb " src="', '"')
            items.append({
                "title": title,
                "url": url, 
                "mode":3, 
                "poster":img,
                "icon":img, 
                "fanart":os.path.join(home, '', 'fanart.jpg'),
                "type":"music", 
                "plot": "",
                "isFolder":True
            })
        except:
            pass
    addMenuItems(items)
            
   
def unescape(string):
    hash={"&#35;": "#", "&#47;": "/", "&#39;" : "\'", "&#43;" : "+"}
    for key, value in hash.iteritems():
        string=string.replace(key, value)
    return string
    
def translate(toTranslate):
    try:
        f={"client":"gtx", "sl":"vi", "tl":"en", "dt":"t", "q":str(toTranslate)}
        translated=getURL("https://translate.googleapis.com/translate_a/single?"+urllib.urlencode(f))
            
        if translated==False:
            return toTranslate
        else:
            j = json.loads(translated)
            return j[0][0][0]
    except:
        logError("Translation error")
    return toTranslate