import xbmc, xbmcgui, xbmcaddon
import os, urllib2, json, sys
from shutil import copyfile
import MyFont
from datetime import datetime
import time


#get actioncodes from https://github.com/xbmc/xbmc/blob/master/xbmc/guilib/Key.h
ACTION_PREVIOUS_MENU = 10
ACTION_SELECT_ITEM = 7
ACTION_MOVE_LEFT = 1
ACTION_MOVE_RIGHT = 2
ACTION_MOVE_UP = 3
ACTION_MOVE_DOWN = 4
xbfont_center_x = 0x00000002
xbfont_center_y = 0x00000004
 
ADDON_ID='script.seedboxescc'
addon=xbmcaddon.Addon(id=ADDON_ID)
home=xbmc.translatePath(addon.getAddonInfo('path').decode('utf-8'))

class MainClass(xbmcgui.WindowDialog):
    def __init__(self):
        self.setCoordinateResolution(2)
        try:
            opener = urllib2.build_opener()
            opener.addheaders = [('Authorization', 'Token token='+xbmc.translatePath(xbmcaddon.Addon().getSetting('api')))]
            page=opener.open('https://www.seedboxes.cc/api/client')
            content=json.loads(page.read())
        except:
            xbmc.executebuiltin( "Dialog.Close(busydialog)" )
            dialog = xbmcgui.Dialog()
            ret = dialog.ok("Seedboxes.cc Account Required", "Error conecting to API. Please check your seedboxes.cc API Key is correct.")
            self.close()
            sys.exit()
        xbmc.executebuiltin( "Dialog.Close(busydialog)" )
        skinFont="seedboxFont"+size
        x=421
        y=119
        self.background = xbmcgui.ControlImage(x,y,448,501, os.path.join(home, 'resources', 'media', 'dialog4.png'))
        self.addControl(self.background)
        
        y=y+118
        
        self.strActionInfo2 = xbmcgui.ControlLabel(x+100, y, 270, 190, content['products'][0]['package']['name']+' ('+content['email']+')', font=skinFont, textColor='0xFFFFFFFF')
        self.addControl(self.strActionInfo2)
        y=y+8
        if content['products'][0]['status']=="Active" :
            self.label =xbmcgui.ControlImage(x+76, y, 10, 10, os.path.join(home, 'resources', 'media', 'active.png'))
        else :
            self.label =xbmcgui.ControlImage(x+70, y, 10, 10, os.path.join(home, 'resources', 'media', 'inactive.png'))
        self.addControl(self.label)
        
        y=y+35
        self.strActionInfo3 = xbmcgui.ControlLabel(x+100, y, 270, 190, 'Total Disk Space Used', font=skinFont, textColor='0xFFFFFFFF')
        self.addControl(self.strActionInfo3)
        y=y+2
        self.label2 =xbmcgui.ControlImage(x+70, y, 20, 20, os.path.join(home, 'resources', 'media', 'space2.png'))
        self.addControl(self.label2)
        y=y+18
        self.strActionInfo4 = xbmcgui.ControlLabel(x+100, y, 270, 190, str(round(content['products'][0]['seedbox']['latest_stats']['diskspace']/float(1000), 2))+'GB of '+str(float(content['products'][0]['seedbox']['disk_space']/float(1)))+"GB", font=skinFont, textColor='0xFFFFFFFF')
        self.addControl(self.strActionInfo4)
        
        y=y+28
        self.strActionInfo5 = xbmcgui.ControlLabel(x+100, y, 270, 190, 'Total Traffic Used', font=skinFont, textColor='0xFFFFFFFF')
        self.addControl(self.strActionInfo5)
        y=y+2
        self.label6 =xbmcgui.ControlImage(x+70, y, 20, 20, os.path.join(home, 'resources', 'media', 'upload2.png'))
        self.addControl(self.label6)
        y=y+18
        self.strActionInfo7 = xbmcgui.ControlLabel(x+100, y, 270, 190, str(round(content['products'][0]['seedbox']['latest_stats']['traffic']/float(1000000), 2))+'TB OF '+str(round(float(content['products'][0]['seedbox']['monthly_traffic']),2))+'TB', font=skinFont, textColor='0xFFFFFFFF')
        self.addControl(self.strActionInfo7)
        try:
            left=round(content['products'][0]['seedbox']['extra_traffic']/float(1000000), 2)
            y=y+20
            self.strActionInfo5 = xbmcgui.ControlLabel(x+100, y, 270, 190, "Extra Traffic Left "+str(left)+"TB", font=skinFont, textColor='0xFFFFFFFF')
            self.addControl(self.strActionInfo5)
        except:
            pass
        """try:
            vpn=round(content['products'][0]['seedbox']['extra_traffic']/float(100000), 2)
            y=y+20
            self.strActionInfo5 = xbmcgui.ControlLabel(x+100, y, 270, 190, "VPN Traffic Used "+str(round(content['products'][0]['seedbox']['latest_stats']['traffic']/float(1000000), 2))+"GB", font=skinFont, textColor='0xFFFFFFFF')
            self.addControl(self.strActionInfo5)
        except:
            pass"""
        
        y=y+28
        self.strActionInfo8 = xbmcgui.ControlLabel(x+100, y, 270, 190, 'Next Invoice Due', font=skinFont, textColor='0xFFFFFFFF')
        self.addControl(self.strActionInfo8)
        y=y+2
        self.label10 =xbmcgui.ControlImage(x+70, y, 20, 20, os.path.join(home, 'resources', 'media', 'invoice3.png'))
        self.addControl(self.label10)
        y=y+18
        s=datetime(*(time.strptime(content['billing_entries'][0]['due_date'], '%Y-%m-%d')[0:6]))
        self.strActionInfo9 = xbmcgui.ControlLabel(x+100, y, 270, 190, b'\x80'.decode('windows-1252')+content['billing_entries'][0]['billing_entries_items'][0]['amount']+" "+s.strftime("%d %B, %Y"), font=skinFont, textColor='0xFFFFFFFF')
        self.addControl(self.strActionInfo9)
        
        try:
            due=len(content['billing_entries'])
            if due>0 and content['billing_entries'][0]['status']=="Unpaid":
                y=y+20
                self.strActionInfo3 = xbmcgui.ControlLabel(x+100, y, 270, 190, 'You currently have '+str(due)+' unpaid invoice', font=skinFont, textColor='0xFFFFFFFF')
                self.addControl(self.strActionInfo3)
        except:
            pass
        y=y+70
        self.button=xbmcgui.ControlButton (x+100, y, 235, 50, 'Close', font=skinFont, focusedColor="0xFFFFFFFF", alignment=xbfont_center_y|xbfont_center_x, focusTexture=os.path.join(home, 'resources', 'media', 'focus.png'), noFocusTexture=os.path.join(home, 'resources', 'media', 'unfocus2.png'))
        self.addControl(self.button)
        self.setFocus(self.button)
        self.button.controlDown(self.button)
        self.button.controlUp(self.button)
        self.button.controlRight(self.button)
        self.button.controlLeft(self.button)

        
    def onControl(self, control):
        if control == self.button:
            self.close()
    
    def onAction(self, action):
        if action == ACTION_PREVIOUS_MENU:
            self.close()

if xbmc.translatePath(xbmcaddon.Addon().getSetting('fontsize'))=="0":
    size="16"
else:
    size="26"

if not MyFont.addFont("seedboxFont"+str(size) , "RobotoCondensed-Regular.ttf" , size): # style and font are optional.
    if not xbmc.translatePath(xbmcaddon.Addon().getSetting('api')):
        dialog = xbmcgui.Dialog()
        ret = dialog.ok("Seedboxes.cc Account Required", "Please add your seedboxes.cc API Key into the settings to use this plugin.")
    else: 
        xbmc.executebuiltin( "ActivateWindow(busydialog)" )
        mydisplay = MainClass()
        mydisplay .doModal()
        del mydisplay
else:
    addon = xbmcaddon.Addon(ADDON_ID)
    xbmc.executebuiltin('Notification(%s, %s, %d, %s)' % (addon.getAddonInfo('name'), "Fonts updated skin refreshed. Please re-open addon.", 3000, addon.getAddonInfo('icon')))