import util
import winwifi
import xbmc, xbmcaddon, sys

if "win" in sys.platform.lower():
    ADDON_ID='script.winwifiman'
    addon=xbmcaddon.Addon(id=ADDON_ID)
    home=xbmc.translatePath(addon.getAddonInfo('path').decode('utf-8'))

    profileDir = addon.getAddonInfo('profile')
    profileDir = xbmc.translatePath(profileDir)

    parameters=util.parseParameters()
    try:
        mode=int(parameters["mode"])
    except:
        mode=None

    set = addon.getSetting('set')


    if set == "Robots":
        set = "set1"
    elif set == "Monsters":
        set = "set2"
    elif set == "Cats":
        set = "set4"
      
    if winwifi.showNetworks() == False:
        util.notify("Wifi is not active")
    else:
        if mode == 1:
            parts = parameters['name'].split("|")
            ssid = parts[0].replace("[COLOR green]", "").strip()
            
            profiles = winwifi.showProfiles()
            
            if ssid in profiles:
                if winwifi.connect(ssid, ssid):
                    xbmc.executebuiltin('Container.Refresh')
                else:
                    util.notify("Unable to connect to WiFi network "+ssid)
            else:
                passphrase = util.searchDialog("Enter passphrase")
                if passphrase:
                    if winwifi.addProfile(ssid, passphrase):
                        if winwifi.connect(ssid, ssid):
                            xbmc.executebuiltin('Container.Refresh')
                        else:
                            util.notify("Unable to connect to WiFi network "+ssid)
                    else:
                        util.notify("Unable to connect to WiFi network "+ssid)
                else:
                    util.notify("Unable to connect to WiFi network "+ssid)
        elif mode == 2:
            parts = parameters['name'].split("|")
            ssid = parts[0].replace("[COLOR green]", "").strip()
            
            if winwifi.forget(ssid):
                util.notify("WiFi network " + ssid + " forgotten")
                xbmc.executebuiltin('Container.Refresh')
            else:
                util.notify("Unable to forget WiFi network " + ssid)
        elif mode == 3:
            parts = parameters['name'].split("|")
            ssid = parts[0].replace("[COLOR green]", "").strip()
            
            if winwifi.disconnect():
                util.notify("Disconnected from " + ssid)
                xbmc.executebuiltin("Container.refresh")
            else:
                util.notify("Unable to disconnect from " + ssid)
        else:
            interface = winwifi.showInterfaces()

            try:
                ssid = str(interface['wifi']['ssid'])
                connected = interface['wifi']['state']
            except:
                connected = "disconnected"
                
            networks = winwifi.showNetworks()

            menu=[]

            for network in networks:
                if connected == "connected":
                    if ssid == str(network['ssid']):
                        title = "[COLOR green]" + str(network['ssid']) + " | " + str(network['authentication']) + " | " + str(network['signal']) + " | CONNECTED[/COLOR]"
                    else:
                        title = str(network['ssid']) + " | " + str(network['authentication']) + " | " + str(network['signal'])
                else:
                    title = str(network['ssid']) + " | " + str(network['authentication']) + " | " + str(network['signal'])
                menu.append({
                    "title": title,
                    "url": "",
                    "mode": "1", 
                    "poster":"https://robohash.org/" + str(network['ssid']) + "?set=" + set,
                    "icon":"https://robohash.org/" + str(network['ssid']) + "?set=" + set, 
                    "fanart":"https://robohash.org/" + str(network['ssid']) + "?set=" + set,
                    "type":"picture", 
                    "plot":"",
                    "isFolder":True
                })
                            
            util.addMenuItems(menu)
else:
    util.alert("This addon is for Windows only.")