import subprocess, os
from operator import itemgetter

import xbmcaddon, xbmc

ADDON_ID='script.winwifiman'
addon=xbmcaddon.Addon(id=ADDON_ID)
home=xbmc.translatePath(addon.getAddonInfo('path').decode('utf-8'))

profileDir = addon.getAddonInfo('profile')
profileDir = xbmc.translatePath(profileDir)

if not os.path.exists(profileDir):
    os.makedirs(profileDir)
    
networksDir = os.path.join(profileDir, "networks")  
 
if not os.path.exists(networksDir):
    os.makedirs(networksDir)
    
def wifiActive(state=True):
    batcmd = 'netsh interface set interface name="Wi-Fi" enable'
    print subprocess.call(['runas', '/user:Paul Thomas', batcmd])
    
def showProfiles():
    batcmd = 'netsh wlan show profiles'
    result = subprocess.check_output(batcmd, shell=True)
    
    result = result.split("\r\n")
    toReturn = []
    for r in result:
        if ":" in r:
            try:
                temp = r.split(":")
                if temp[1]:
                    toReturn.append(temp[1].strip())
            except:
                pass
    return toReturn if toReturn else Falsefdis

def showNetworks():
    try:
        batcmd = 'netsh wlan show networks mode=bssid'
        result = subprocess.check_output(batcmd, shell=True)
    except:
        return False
        
    result = result.split("\r\n\r\n")
    toReturn = []
    
    for r in result:
        try:
            temp = r.split("\n")
            ssid = temp[0].split(":")[1].strip()
            signal = temp[5].split(":")[1].strip()
            auth = temp[2].split(":")[1].strip()
            
            toReturn.append({"ssid" : ssid, "signal" : signal, "authentication" : auth})
        except:
            pass
    
    try:
        toReturn = sorted(toReturn, key=itemgetter('signal'), reverse=True)
    except:
        pass
    
    return toReturn if toReturn else False

def showInterfaces():    
    batcmd = 'netsh wlan show interfaces'
    result = subprocess.check_output(batcmd, shell=True)

    result = result.split("\r\n")
    toReturn = {}

    for r in result:
        if ":" in r:
            temp = r.split(":")
            title = temp[0].lower().strip()
            
            if title == "name" : 
                toReturn['wifi'] = {}
            elif title == "state" or title == "ssid":
                toReturn['wifi'][title] = temp[1].strip()
                
    return toReturn if toReturn else False    
    
def addProfile(ssid, password): 
    xml = '<?xml version="1.0"?><WLANProfile xmlns="http://www.microsoft.com/networking/WLAN/profile/v1"><name>{SSID}</name><SSIDConfig><SSID><name>{SSID}</name></SSID></SSIDConfig><connectionType>ESS</connectionType><connectionMode>auto</connectionMode><MSM><security><authEncryption><authentication>WPA2PSK</authentication><encryption>AES</encryption><useOneX>false</useOneX></authEncryption><sharedKey><keyType>passPhrase</keyType><protected>false</protected><keyMaterial>{password}</keyMaterial></sharedKey></security></MSM><MacRandomization xmlns="http://www.microsoft.com/networking/WLAN/profile/v3"><enableRandomization>false</enableRandomization></MacRandomization></WLANProfile>'
    
    path = os.path.join(networksDir, str(ssid)+".xml")
    
    file = open (path , "w")
    file.write(xml.replace("{SSID}",  ssid).replace("{password}", password))
    file.close()

    try:
        batcmd = 'netsh wlan add profile filename="' + path + '"'
        result = subprocess.check_output(batcmd, shell=True)
    except:
        result = "failed"

    os.remove(path)
    
    return True if "is added on interface" in result else False
    
def connect(ssid, profile):
    try:
        batcmd = 'netsh wlan connect ssid="'+str(ssid)+'" name="'+str(profile)+'"'
        result = subprocess.check_output(batcmd, shell=True)
        
        return True if "completed successfully" in result else False
    except:
        return False

def disconnect():
    try:
        batcmd = 'netsh wlan disconnect'
        result = subprocess.check_output(batcmd, shell=True)
        
        return True if "completed successfully" in result else False
    except:
        return False
        
def forget(profile):
    batcmd = 'netsh wlan delete profile name="'+profile+'"'
    result = subprocess.check_output(batcmd, shell=True)
    
    return True if "is deleted from interface" in result else False

def ipconfig():
    batcmd = 'ipconfig'
    result = subprocess.check_output(batcmd, shell=True)
    
    result = result.split("\r\n")
    toReturn = {}
    wifi = False
    
    for r in result:
        if "wi-fi" in r.lower():
            wifi = True
            
        if wifi:
            if "ipv4" in r.lower():
                try:
                    toReturn['ip']
                except:
                    temp = r.split(":")
                    toReturn['ip'] = temp[1].strip()
            elif "subnet" in r.lower():
                try:
                    toReturn['subnet']
                except:
                    temp = r.split(":")
                    toReturn['subnet'] = temp[1].strip()
            elif "gateway" in r.lower():
                try:
                    toReturn['gateway']
                except:
                    temp = r.split(":")
                    toReturn['gateway'] = temp[1].strip()
    
    return toReturn if toReturn else False