# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from linebot.v3.audience.models.audience_group_create_route import AudienceGroupCreateRoute
from linebot.v3.audience.models.audience_group_failed_type import AudienceGroupFailedType
from linebot.v3.audience.models.audience_group_permission import AudienceGroupPermission
from linebot.v3.audience.models.audience_group_status import AudienceGroupStatus
from linebot.v3.audience.models.audience_group_type import AudienceGroupType

class AudienceGroup(BaseModel):
    """
    Audience group
    """
    audience_group_id: Optional[StrictInt] = Field(None, alias="audienceGroupId", description="The audience ID.")
    type: Optional[AudienceGroupType] = None
    description: Optional[StrictStr] = Field(None, description="The audience's name.")
    status: Optional[AudienceGroupStatus] = None
    failed_type: Optional[AudienceGroupFailedType] = Field(None, alias="failedType")
    audience_count: Optional[StrictInt] = Field(None, alias="audienceCount", description="The number of users included in the audience.")
    created: Optional[StrictInt] = Field(None, description="When the audience was created (in UNIX time).")
    request_id: Optional[StrictStr] = Field(None, alias="requestId", description="The request ID that was specified when the audience was created. This is only included when `audienceGroup.type` is CLICK or IMP. ")
    click_url: Optional[StrictStr] = Field(None, alias="clickUrl", description="The URL that was specified when the audience was created. This is only included when `audienceGroup.type` is CLICK and link URL is specified. ")
    is_ifa_audience: Optional[StrictBool] = Field(None, alias="isIfaAudience", description="The value indicating the type of account to be sent, as specified when creating the audience for uploading user IDs. ")
    permission: Optional[AudienceGroupPermission] = None
    create_route: Optional[AudienceGroupCreateRoute] = Field(None, alias="createRoute")

    __properties = ["audienceGroupId", "type", "description", "status", "failedType", "audienceCount", "created", "requestId", "clickUrl", "isIfaAudience", "permission", "createRoute"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AudienceGroup:
        """Create an instance of AudienceGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if failed_type (nullable) is None
        # and __fields_set__ contains the field
        if self.failed_type is None and "failed_type" in self.__fields_set__:
            _dict['failedType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AudienceGroup:
        """Create an instance of AudienceGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AudienceGroup.parse_obj(obj)

        _obj = AudienceGroup.parse_obj({
            "audience_group_id": obj.get("audienceGroupId"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "failed_type": obj.get("failedType"),
            "audience_count": obj.get("audienceCount"),
            "created": obj.get("created"),
            "request_id": obj.get("requestId"),
            "click_url": obj.get("clickUrl"),
            "is_ifa_audience": obj.get("isIfaAudience"),
            "permission": obj.get("permission"),
            "create_route": obj.get("createRoute")
        })
        return _obj

