# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, validator
from linebot.v3.audience.models.audience_group_type import AudienceGroupType

class CreateAudienceGroupResponse(BaseModel):
    """
    Create audience for uploading user IDs (by JSON)
    https://developers.line.biz/en/reference/messaging-api/#create-upload-audience-group
    """
    audience_group_id: Optional[StrictInt] = Field(None, alias="audienceGroupId", description="The audience ID.")
    create_route: Optional[StrictStr] = Field(None, alias="createRoute", description="How the audience was created.  `MESSAGING_API`: An audience created with Messaging API. ")
    type: Optional[AudienceGroupType] = None
    description: Optional[StrictStr] = Field(None, description="The audience's name.")
    created: Optional[StrictInt] = Field(None, description="When the audience was created (in UNIX time).")
    permission: Optional[StrictStr] = Field(None, description="Audience's update permission. Audiences linked to the same channel will be READ_WRITE.  `READ`: Can use only. `READ_WRITE`: Can use and update. ")
    expire_timestamp: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="expireTimestamp", description="Time of audience expiration. Only returned for specific audiences. ")
    is_ifa_audience: Optional[StrictBool] = Field(None, alias="isIfaAudience", description="The value indicating the type of account to be sent, as specified when creating the audience for uploading user IDs. One of:  `true`: Accounts are specified with IFAs. `false` (default): Accounts are specified with user IDs. ")

    __properties = ["audienceGroupId", "createRoute", "type", "description", "created", "permission", "expireTimestamp", "isIfaAudience"]

    @validator('create_route')
    def create_route_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('MESSAGING_API'):
            raise ValueError("must be one of enum values ('MESSAGING_API')")
        return value

    @validator('permission')
    def permission_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('READ', 'READ_WRITE'):
            raise ValueError("must be one of enum values ('READ', 'READ_WRITE')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateAudienceGroupResponse:
        """Create an instance of CreateAudienceGroupResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAudienceGroupResponse:
        """Create an instance of CreateAudienceGroupResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateAudienceGroupResponse.parse_obj(obj)

        _obj = CreateAudienceGroupResponse.parse_obj({
            "audience_group_id": obj.get("audienceGroupId"),
            "create_route": obj.get("createRoute"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "created": obj.get("created"),
            "permission": obj.get("permission"),
            "expire_timestamp": obj.get("expireTimestamp"),
            "is_ifa_audience": obj.get("isIfaAudience")
        })
        return _obj

