# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from linebot.v3.audience.models.audience_group_type import AudienceGroupType

class CreateImpBasedAudienceGroupResponse(BaseModel):
    """
    Create audience for impression-based retargeting
    https://developers.line.biz/en/reference/messaging-api/#create-imp-audience-group
    """
    audience_group_id: Optional[StrictInt] = Field(None, alias="audienceGroupId", description="The audience ID.")
    type: Optional[AudienceGroupType] = None
    description: Optional[StrictStr] = Field(None, description="The audience's name.")
    created: Optional[StrictInt] = Field(None, description="When the audience was created (in UNIX time).")
    request_id: Optional[StrictStr] = Field(None, alias="requestId", description="The request ID that was specified when the audience was created.")

    __properties = ["audienceGroupId", "type", "description", "created", "requestId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateImpBasedAudienceGroupResponse:
        """Create an instance of CreateImpBasedAudienceGroupResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateImpBasedAudienceGroupResponse:
        """Create an instance of CreateImpBasedAudienceGroupResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateImpBasedAudienceGroupResponse.parse_obj(obj)

        _obj = CreateImpBasedAudienceGroupResponse.parse_obj({
            "audience_group_id": obj.get("audienceGroupId"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "created": obj.get("created"),
            "request_id": obj.get("requestId")
        })
        return _obj

