# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, conlist
from linebot.v3.audience.models.audience_group import AudienceGroup

class GetAudienceGroupsResponse(BaseModel):
    """
    Gets data for more than one audience.
    https://developers.line.biz/en/reference/messaging-api/#get-audience-groups
    """
    audience_groups: Optional[conlist(AudienceGroup)] = Field(None, alias="audienceGroups", description="An array of audience data. If there are no audiences that match the specified filter, an empty array will be returned.")
    has_next_page: Optional[StrictBool] = Field(None, alias="hasNextPage", description="true when this is not the last page.")
    total_count: Optional[StrictInt] = Field(None, alias="totalCount", description="The total number of audiences that can be returned with the specified filter.")
    read_write_audience_group_total_count: Optional[StrictInt] = Field(None, alias="readWriteAudienceGroupTotalCount", description="Of the audiences you can get with the specified filter, the number of audiences with the update permission set to READ_WRITE.")
    page: Optional[StrictInt] = Field(None, description="The current page number.")
    size: Optional[StrictInt] = Field(None, description="The maximum number of audiences on the current page.")

    __properties = ["audienceGroups", "hasNextPage", "totalCount", "readWriteAudienceGroupTotalCount", "page", "size"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetAudienceGroupsResponse:
        """Create an instance of GetAudienceGroupsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in audience_groups (list)
        _items = []
        if self.audience_groups:
            for _item in self.audience_groups:
                if _item:
                    _items.append(_item.to_dict())
            _dict['audienceGroups'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetAudienceGroupsResponse:
        """Create an instance of GetAudienceGroupsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetAudienceGroupsResponse.parse_obj(obj)

        _obj = GetAudienceGroupsResponse.parse_obj({
            "audience_groups": [AudienceGroup.from_dict(_item) for _item in obj.get("audienceGroups")] if obj.get("audienceGroups") is not None else None,
            "has_next_page": obj.get("hasNextPage"),
            "total_count": obj.get("totalCount"),
            "read_write_audience_group_total_count": obj.get("readWriteAudienceGroupTotalCount"),
            "page": obj.get("page"),
            "size": obj.get("size")
        })
        return _obj

