# coding: utf-8

"""
    LINE Messaging API(Insight)

    This document describes LINE Messaging API(Insight).  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing_extensions import Annotated
from typing import overload, Optional, Union, Awaitable

from pydantic.v1 import Field, constr, validator

from typing import Optional

from linebot.v3.insight.models.get_friends_demographics_response import GetFriendsDemographicsResponse
from linebot.v3.insight.models.get_message_event_response import GetMessageEventResponse
from linebot.v3.insight.models.get_number_of_followers_response import GetNumberOfFollowersResponse
from linebot.v3.insight.models.get_number_of_message_deliveries_response import GetNumberOfMessageDeliveriesResponse
from linebot.v3.insight.models.get_statistics_per_unit_response import GetStatisticsPerUnitResponse

from linebot.v3.insight.async_api_client import AsyncApiClient
from linebot.v3.insight.api_response import ApiResponse
from linebot.v3.insight.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AsyncInsight(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = AsyncApiClient.get_default()
        self.api_client = api_client
        self.line_base_path = "https://api.line.me"


    @overload
    async def get_friends_demographics(self, **kwargs) -> GetFriendsDemographicsResponse:  # noqa: E501
        ...

    @overload
    def get_friends_demographics(self, async_req: Optional[bool]=True, **kwargs) -> GetFriendsDemographicsResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_friends_demographics(self, async_req: Optional[bool]=None, **kwargs) -> Union[GetFriendsDemographicsResponse, Awaitable[GetFriendsDemographicsResponse]]:  # noqa: E501
        """get_friends_demographics  # noqa: E501

        Retrieves the demographic attributes for a LINE Official Account's friends.You can only retrieve information about friends for LINE Official Accounts created by users in Japan (JP), Thailand (TH), Taiwan (TW) and Indonesia (ID).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_friends_demographics(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetFriendsDemographicsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_friends_demographics_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_friends_demographics_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_friends_demographics_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_friends_demographics  # noqa: E501

        Retrieves the demographic attributes for a LINE Official Account's friends.You can only retrieve information about friends for LINE Official Accounts created by users in Japan (JP), Thailand (TH), Taiwan (TW) and Indonesia (ID).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_friends_demographics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetFriendsDemographicsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_friends_demographics" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Bearer']  # noqa: E501

        _response_types_map = {
            '200': "GetFriendsDemographicsResponse",
        }

        return self.api_client.call_api(
            '/v2/bot/insight/demographic', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_message_event(self, request_id : Annotated[constr(strict=True, min_length=1), Field(..., description="Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID. ")], **kwargs) -> GetMessageEventResponse:  # noqa: E501
        ...

    @overload
    def get_message_event(self, request_id : Annotated[constr(strict=True, min_length=1), Field(..., description="Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID. ")], async_req: Optional[bool]=True, **kwargs) -> GetMessageEventResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_message_event(self, request_id : Annotated[constr(strict=True, min_length=1), Field(..., description="Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID. ")], async_req: Optional[bool]=None, **kwargs) -> Union[GetMessageEventResponse, Awaitable[GetMessageEventResponse]]:  # noqa: E501
        """Get user interaction statistics  # noqa: E501

        Returns statistics about how users interact with narrowcast messages or broadcast messages sent from your LINE Official Account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_message_event(request_id, async_req=True)
        >>> result = thread.get()

        :param request_id: Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID.  (required)
        :type request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetMessageEventResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_message_event_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_message_event_with_http_info(request_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_message_event_with_http_info(self, request_id : Annotated[constr(strict=True, min_length=1), Field(..., description="Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID. ")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get user interaction statistics  # noqa: E501

        Returns statistics about how users interact with narrowcast messages or broadcast messages sent from your LINE Official Account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_message_event_with_http_info(request_id, async_req=True)
        >>> result = thread.get()

        :param request_id: Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID.  (required)
        :type request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetMessageEventResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_message_event" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('request_id') is not None:  # noqa: E501
            _query_params.append(('requestId', _params['request_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Bearer']  # noqa: E501

        _response_types_map = {
            '200': "GetMessageEventResponse",
        }

        return self.api_client.call_api(
            '/v2/bot/insight/message/event', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_number_of_followers(self, var_date : Annotated[Optional[constr(strict=True, max_length=8, min_length=8)], Field(description="Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9 ")] = None, **kwargs) -> GetNumberOfFollowersResponse:  # noqa: E501
        ...

    @overload
    def get_number_of_followers(self, var_date : Annotated[Optional[constr(strict=True, max_length=8, min_length=8)], Field(description="Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9 ")] = None, async_req: Optional[bool]=True, **kwargs) -> GetNumberOfFollowersResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_number_of_followers(self, var_date : Annotated[Optional[constr(strict=True, max_length=8, min_length=8)], Field(description="Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9 ")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GetNumberOfFollowersResponse, Awaitable[GetNumberOfFollowersResponse]]:  # noqa: E501
        """Get number of followers  # noqa: E501

        Returns the number of users who have added the LINE Official Account on or before a specified date.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_number_of_followers(var_date, async_req=True)
        >>> result = thread.get()

        :param var_date: Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9 
        :type var_date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetNumberOfFollowersResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_number_of_followers_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_number_of_followers_with_http_info(var_date, **kwargs)  # noqa: E501

    @validate_arguments
    def get_number_of_followers_with_http_info(self, var_date : Annotated[Optional[constr(strict=True, max_length=8, min_length=8)], Field(description="Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9 ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get number of followers  # noqa: E501

        Returns the number of users who have added the LINE Official Account on or before a specified date.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_number_of_followers_with_http_info(var_date, async_req=True)
        >>> result = thread.get()

        :param var_date: Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9 
        :type var_date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetNumberOfFollowersResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'var_date'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_number_of_followers" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('var_date') is not None:  # noqa: E501
            _query_params.append(('date', _params['var_date']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Bearer']  # noqa: E501

        _response_types_map = {
            '200': "GetNumberOfFollowersResponse",
        }

        return self.api_client.call_api(
            '/v2/bot/insight/followers', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_number_of_message_deliveries(self, var_date : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9 ")], **kwargs) -> GetNumberOfMessageDeliveriesResponse:  # noqa: E501
        ...

    @overload
    def get_number_of_message_deliveries(self, var_date : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9 ")], async_req: Optional[bool]=True, **kwargs) -> GetNumberOfMessageDeliveriesResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_number_of_message_deliveries(self, var_date : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9 ")], async_req: Optional[bool]=None, **kwargs) -> Union[GetNumberOfMessageDeliveriesResponse, Awaitable[GetNumberOfMessageDeliveriesResponse]]:  # noqa: E501
        """Get number of message deliveries  # noqa: E501

        Returns the number of messages sent from LINE Official Account on a specified day.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_number_of_message_deliveries(var_date, async_req=True)
        >>> result = thread.get()

        :param var_date: Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9  (required)
        :type var_date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetNumberOfMessageDeliveriesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_number_of_message_deliveries_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_number_of_message_deliveries_with_http_info(var_date, **kwargs)  # noqa: E501

    @validate_arguments
    def get_number_of_message_deliveries_with_http_info(self, var_date : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9 ")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get number of message deliveries  # noqa: E501

        Returns the number of messages sent from LINE Official Account on a specified day.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_number_of_message_deliveries_with_http_info(var_date, async_req=True)
        >>> result = thread.get()

        :param var_date: Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9  (required)
        :type var_date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetNumberOfMessageDeliveriesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'var_date'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_number_of_message_deliveries" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('var_date') is not None:  # noqa: E501
            _query_params.append(('date', _params['var_date']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Bearer']  # noqa: E501

        _response_types_map = {
            '200': "GetNumberOfMessageDeliveriesResponse",
        }

        return self.api_client.call_api(
            '/v2/bot/insight/message/delivery', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_statistics_per_unit(self, custom_aggregation_unit : Annotated[constr(strict=True, max_length=30, min_length=1), Field(..., description="Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names. ")], var_from : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9 ")], to : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9 ")], **kwargs) -> GetStatisticsPerUnitResponse:  # noqa: E501
        ...

    @overload
    def get_statistics_per_unit(self, custom_aggregation_unit : Annotated[constr(strict=True, max_length=30, min_length=1), Field(..., description="Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names. ")], var_from : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9 ")], to : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9 ")], async_req: Optional[bool]=True, **kwargs) -> GetStatisticsPerUnitResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_statistics_per_unit(self, custom_aggregation_unit : Annotated[constr(strict=True, max_length=30, min_length=1), Field(..., description="Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names. ")], var_from : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9 ")], to : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9 ")], async_req: Optional[bool]=None, **kwargs) -> Union[GetStatisticsPerUnitResponse, Awaitable[GetStatisticsPerUnitResponse]]:  # noqa: E501
        """get_statistics_per_unit  # noqa: E501

        You can check the per-unit statistics of how users interact with push messages and multicast messages sent from your LINE Official Account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_statistics_per_unit(custom_aggregation_unit, var_from, to, async_req=True)
        >>> result = thread.get()

        :param custom_aggregation_unit: Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names.  (required)
        :type custom_aggregation_unit: str
        :param var_from: Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9  (required)
        :type var_from: str
        :param to: End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9  (required)
        :type to: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStatisticsPerUnitResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_statistics_per_unit_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_statistics_per_unit_with_http_info(custom_aggregation_unit, var_from, to, **kwargs)  # noqa: E501

    @validate_arguments
    def get_statistics_per_unit_with_http_info(self, custom_aggregation_unit : Annotated[constr(strict=True, max_length=30, min_length=1), Field(..., description="Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names. ")], var_from : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9 ")], to : Annotated[constr(strict=True, max_length=8, min_length=8), Field(..., description="End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9 ")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_statistics_per_unit  # noqa: E501

        You can check the per-unit statistics of how users interact with push messages and multicast messages sent from your LINE Official Account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_statistics_per_unit_with_http_info(custom_aggregation_unit, var_from, to, async_req=True)
        >>> result = thread.get()

        :param custom_aggregation_unit: Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names.  (required)
        :type custom_aggregation_unit: str
        :param var_from: Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9  (required)
        :type var_from: str
        :param to: End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9  (required)
        :type to: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStatisticsPerUnitResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'custom_aggregation_unit',
            'var_from',
            'to'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_per_unit" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('custom_aggregation_unit') is not None:  # noqa: E501
            _query_params.append(('customAggregationUnit', _params['custom_aggregation_unit']))

        if _params.get('var_from') is not None:  # noqa: E501
            _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            _query_params.append(('to', _params['to']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Bearer']  # noqa: E501

        _response_types_map = {
            '200': "GetStatisticsPerUnitResponse",
        }

        return self.api_client.call_api(
            '/v2/bot/insight/message/event/aggregation', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
