# coding: utf-8

"""
    LINE Messaging API(Insight)

    This document describes LINE Messaging API(Insight).  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr

class GetMessageEventResponseClick(BaseModel):
    """
    GetMessageEventResponseClick
    """
    seq: Optional[StrictInt] = Field(None, description="The URL's serial number.")
    url: Optional[StrictStr] = Field(None, description="URL.")
    click: Optional[StrictInt] = Field(None, description="Number of times the URL was opened.")
    unique_click: Optional[StrictInt] = Field(None, alias="uniqueClick", description="Number of users that opened the URL.")
    unique_click_of_request: Optional[StrictInt] = Field(None, alias="uniqueClickOfRequest", description="Number of users who opened this url through any link in the message. If a message contains two links to the same URL and a user opens both links, they're counted only once.")

    __properties = ["seq", "url", "click", "uniqueClick", "uniqueClickOfRequest"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetMessageEventResponseClick:
        """Create an instance of GetMessageEventResponseClick from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if click (nullable) is None
        # and __fields_set__ contains the field
        if self.click is None and "click" in self.__fields_set__:
            _dict['click'] = None

        # set to None if unique_click (nullable) is None
        # and __fields_set__ contains the field
        if self.unique_click is None and "unique_click" in self.__fields_set__:
            _dict['uniqueClick'] = None

        # set to None if unique_click_of_request (nullable) is None
        # and __fields_set__ contains the field
        if self.unique_click_of_request is None and "unique_click_of_request" in self.__fields_set__:
            _dict['uniqueClickOfRequest'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetMessageEventResponseClick:
        """Create an instance of GetMessageEventResponseClick from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetMessageEventResponseClick.parse_obj(obj)

        _obj = GetMessageEventResponseClick.parse_obj({
            "seq": obj.get("seq"),
            "url": obj.get("url"),
            "click": obj.get("click"),
            "unique_click": obj.get("uniqueClick"),
            "unique_click_of_request": obj.get("uniqueClickOfRequest")
        })
        return _obj

