# coding: utf-8

"""
    LINE Messaging API(Insight)

    This document describes LINE Messaging API(Insight).  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic.v1 import BaseModel, Field, conlist
from linebot.v3.insight.models.get_statistics_per_unit_response_click import GetStatisticsPerUnitResponseClick
from linebot.v3.insight.models.get_statistics_per_unit_response_message import GetStatisticsPerUnitResponseMessage
from linebot.v3.insight.models.get_statistics_per_unit_response_overview import GetStatisticsPerUnitResponseOverview

class GetStatisticsPerUnitResponse(BaseModel):
    """
    Response object for `get statistics per unit`
    https://developers.line.biz/en/reference/messaging-api/#get-statistics-per-unit-response
    """
    overview: GetStatisticsPerUnitResponseOverview = Field(...)
    messages: conlist(GetStatisticsPerUnitResponseMessage) = Field(..., description="Array of information about individual message bubbles.")
    clicks: conlist(GetStatisticsPerUnitResponseClick) = Field(..., description="Array of information about opened URLs in the message.")

    __properties = ["overview", "messages", "clicks"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetStatisticsPerUnitResponse:
        """Create an instance of GetStatisticsPerUnitResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of overview
        if self.overview:
            _dict['overview'] = self.overview.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['messages'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in clicks (list)
        _items = []
        if self.clicks:
            for _item in self.clicks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['clicks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetStatisticsPerUnitResponse:
        """Create an instance of GetStatisticsPerUnitResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetStatisticsPerUnitResponse.parse_obj(obj)

        _obj = GetStatisticsPerUnitResponse.parse_obj({
            "overview": GetStatisticsPerUnitResponseOverview.from_dict(obj.get("overview")) if obj.get("overview") is not None else None,
            "messages": [GetStatisticsPerUnitResponseMessage.from_dict(_item) for _item in obj.get("messages")] if obj.get("messages") is not None else None,
            "clicks": [GetStatisticsPerUnitResponseClick.from_dict(_item) for _item in obj.get("clicks")] if obj.get("clicks") is not None else None
        })
        return _obj

