# coding: utf-8

"""
    LINE Messaging API(Insight)

    This document describes LINE Messaging API(Insight).  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt

class GetStatisticsPerUnitResponseOverview(BaseModel):
    """
    Statistics related to messages.
    https://developers.line.biz/en/reference/messaging-api/#get-statistics-per-unit-response
    """
    unique_impression: Optional[StrictInt] = Field(None, alias="uniqueImpression", description="Number of users who opened the message, meaning they displayed at least 1 bubble.")
    unique_click: Optional[StrictInt] = Field(None, alias="uniqueClick", description="Number of users who opened any URL in the message.")
    unique_media_played: Optional[StrictInt] = Field(None, alias="uniqueMediaPlayed", description="Number of users who started playing any video or audio in the message.")
    unique_media_played100_percent: Optional[StrictInt] = Field(None, alias="uniqueMediaPlayed100Percent", description="Number of users who played the entirety of any video or audio in the message.")

    __properties = ["uniqueImpression", "uniqueClick", "uniqueMediaPlayed", "uniqueMediaPlayed100Percent"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetStatisticsPerUnitResponseOverview:
        """Create an instance of GetStatisticsPerUnitResponseOverview from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if unique_impression (nullable) is None
        # and __fields_set__ contains the field
        if self.unique_impression is None and "unique_impression" in self.__fields_set__:
            _dict['uniqueImpression'] = None

        # set to None if unique_click (nullable) is None
        # and __fields_set__ contains the field
        if self.unique_click is None and "unique_click" in self.__fields_set__:
            _dict['uniqueClick'] = None

        # set to None if unique_media_played (nullable) is None
        # and __fields_set__ contains the field
        if self.unique_media_played is None and "unique_media_played" in self.__fields_set__:
            _dict['uniqueMediaPlayed'] = None

        # set to None if unique_media_played100_percent (nullable) is None
        # and __fields_set__ contains the field
        if self.unique_media_played100_percent is None and "unique_media_played100_percent" in self.__fields_set__:
            _dict['uniqueMediaPlayed100Percent'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetStatisticsPerUnitResponseOverview:
        """Create an instance of GetStatisticsPerUnitResponseOverview from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetStatisticsPerUnitResponseOverview.parse_obj(obj)

        _obj = GetStatisticsPerUnitResponseOverview.parse_obj({
            "unique_impression": obj.get("uniqueImpression"),
            "unique_click": obj.get("uniqueClick"),
            "unique_media_played": obj.get("uniqueMediaPlayed"),
            "unique_media_played100_percent": obj.get("uniqueMediaPlayed100Percent")
        })
        return _obj

