# coding: utf-8

"""
    LIFF server API

    LIFF Server API.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, validator

class LiffView(BaseModel):
    """
    LiffView
    https://developers.line.biz/en/reference/liff-server/#add-liff-app
    """
    type: StrictStr = Field(..., description="Size of the LIFF app view. Specify one of these values: - compact - tall - full ")
    url: StrictStr = Field(..., description="Endpoint URL. This is the URL of the web app that implements the LIFF app (e.g. https://example.com). Used when the LIFF app is launched using the LIFF URL. The URL scheme must be https. URL fragments (#URL-fragment) can't be specified. ")
    module_mode: Optional[StrictBool] = Field(None, alias="moduleMode", description="`true` to use the LIFF app in modular mode. When in modular mode, the action button in the header is not displayed. ")

    __properties = ["type", "url", "moduleMode"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('compact', 'tall', 'full'):
            raise ValueError("must be one of enum values ('compact', 'tall', 'full')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LiffView:
        """Create an instance of LiffView from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LiffView:
        """Create an instance of LiffView from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LiffView.parse_obj(obj)

        _obj = LiffView.parse_obj({
            "type": obj.get("type"),
            "url": obj.get("url"),
            "module_mode": obj.get("moduleMode")
        })
        return _obj

