# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import Field, constr
from linebot.v3.messaging.models.action import Action

class ClipboardAction(Action):
    """
    ClipboardAction
    https://developers.line.biz/en/reference/messaging-api/#clipboard-action
    """
    clipboard_text: constr(strict=True, max_length=1000, min_length=1) = Field(..., alias="clipboardText", description="Text that is copied to the clipboard. Max character limit: 1000 ")
    type: str = "clipboard"

    __properties = ["type", "label", "clipboardText"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ClipboardAction:
        """Create an instance of ClipboardAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ClipboardAction:
        """Create an instance of ClipboardAction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ClipboardAction.parse_obj(obj)

        _obj = ClipboardAction.parse_obj({
            "type": obj.get("type"),
            "label": obj.get("label"),
            "clipboard_text": obj.get("clipboardText")
        })
        return _obj

