# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist
from linebot.v3.messaging.models.error_detail import ErrorDetail
from linebot.v3.messaging.models.sent_message import SentMessage

class ErrorResponse(BaseModel):
    """
    ErrorResponse
    https://developers.line.biz/en/reference/messaging-api/#error-responses
    """
    message: StrictStr = Field(..., description="Message containing information about the error.")
    details: Optional[conlist(ErrorDetail)] = Field(None, description="An array of error details. If the array is empty, this property will not be included in the response.")
    sent_messages: Optional[conlist(SentMessage, max_items=5, min_items=1)] = Field(None, alias="sentMessages", description="Array of sent messages.")

    __properties = ["message", "details", "sentMessages"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorResponse:
        """Create an instance of ErrorResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in details (list)
        _items = []
        if self.details:
            for _item in self.details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['details'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in sent_messages (list)
        _items = []
        if self.sent_messages:
            for _item in self.sent_messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sentMessages'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorResponse:
        """Create an instance of ErrorResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ErrorResponse.parse_obj(obj)

        _obj = ErrorResponse.parse_obj({
            "message": obj.get("message"),
            "details": [ErrorDetail.from_dict(_item) for _item in obj.get("details")] if obj.get("details") is not None else None,
            "sent_messages": [SentMessage.from_dict(_item) for _item in obj.get("sentMessages")] if obj.get("sentMessages") is not None else None
        })
        return _obj

