# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import Field, StrictBool, StrictInt, StrictStr, validator
from linebot.v3.messaging.models.action import Action
from linebot.v3.messaging.models.flex_component import FlexComponent

class FlexImage(FlexComponent):
    """
    FlexImage
    https://developers.line.biz/en/reference/messaging-api/#f-image
    """
    url: StrictStr = Field(..., description="Image URL (Max character limit: 2000) Protocol: HTTPS (TLS 1.2 or later) Image format: JPEG or PNG Maximum image size: 1024×1024 pixels Maximum file size: 10 MB (300 KB when the animated property is true) ")
    flex: Optional[StrictInt] = Field(None, description="The ratio of the width or height of this component within the parent box.")
    margin: Optional[StrictStr] = Field(None, description="The minimum amount of space to include before this component in its parent container. ")
    position: Optional[StrictStr] = Field(None, description="Reference for offsetTop, offsetBottom, offsetStart, and offsetEnd. Specify one of the following values:  `relative`: Use the previous box as reference. `absolute`: Use the top left of parent element as reference. The default value is relative. ")
    offset_top: Optional[StrictStr] = Field(None, alias="offsetTop", description="Offset.")
    offset_bottom: Optional[StrictStr] = Field(None, alias="offsetBottom", description="Offset.")
    offset_start: Optional[StrictStr] = Field(None, alias="offsetStart", description="Offset.")
    offset_end: Optional[StrictStr] = Field(None, alias="offsetEnd", description="Offset.")
    align: Optional[StrictStr] = Field(None, description="Alignment style in horizontal direction. ")
    gravity: Optional[StrictStr] = Field(None, description="Alignment style in vertical direction.")
    size: Optional[StrictStr] = Field('md', description="The maximum image width. This is md by default. ")
    aspect_ratio: Optional[StrictStr] = Field(None, alias="aspectRatio", description="Aspect ratio of the image. `{width}:{height}` format. Specify the value of `{width}` and `{height}` in the range from `1` to `100000`. However, you cannot set `{height}` to a value that is more than three times the value of `{width}`. The default value is `1:1`. ")
    aspect_mode: Optional[StrictStr] = Field(None, alias="aspectMode", description="The display style of the image if the aspect ratio of the image and that specified by the aspectRatio property do not match. ")
    background_color: Optional[StrictStr] = Field(None, alias="backgroundColor", description="Background color of the image. Use a hexadecimal color code.")
    action: Optional[Action] = None
    animated: Optional[StrictBool] = Field(False, description="When this is `true`, an animated image (APNG) plays. You can specify a value of true up to 10 images in a single message. You can't send messages that exceed this limit. This is `false` by default. Animated images larger than 300 KB aren't played back. ")
    type: str = "image"

    __properties = ["type", "url", "flex", "margin", "position", "offsetTop", "offsetBottom", "offsetStart", "offsetEnd", "align", "gravity", "size", "aspectRatio", "aspectMode", "backgroundColor", "action", "animated"]

    @validator('position')
    def position_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('relative', 'absolute'):
            raise ValueError("must be one of enum values ('relative', 'absolute')")
        return value

    @validator('align')
    def align_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('start', 'end', 'center'):
            raise ValueError("must be one of enum values ('start', 'end', 'center')")
        return value

    @validator('gravity')
    def gravity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('top', 'bottom', 'center'):
            raise ValueError("must be one of enum values ('top', 'bottom', 'center')")
        return value

    @validator('aspect_mode')
    def aspect_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('fit', 'cover'):
            raise ValueError("must be one of enum values ('fit', 'cover')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FlexImage:
        """Create an instance of FlexImage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of action
        if self.action:
            _dict['action'] = self.action.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FlexImage:
        """Create an instance of FlexImage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FlexImage.parse_obj(obj)

        _obj = FlexImage.parse_obj({
            "type": obj.get("type"),
            "url": obj.get("url"),
            "flex": obj.get("flex"),
            "margin": obj.get("margin"),
            "position": obj.get("position"),
            "offset_top": obj.get("offsetTop"),
            "offset_bottom": obj.get("offsetBottom"),
            "offset_start": obj.get("offsetStart"),
            "offset_end": obj.get("offsetEnd"),
            "align": obj.get("align"),
            "gravity": obj.get("gravity"),
            "size": obj.get("size") if obj.get("size") is not None else 'md',
            "aspect_ratio": obj.get("aspectRatio"),
            "aspect_mode": obj.get("aspectMode"),
            "background_color": obj.get("backgroundColor"),
            "action": Action.from_dict(obj.get("action")) if obj.get("action") is not None else None,
            "animated": obj.get("animated") if obj.get("animated") is not None else False
        })
        return _obj

