# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field, StrictStr, validator

class GetMessageContentTranscodingResponse(BaseModel):
    """
    Transcoding response
    https://developers.line.biz/en/reference/messaging-api/#verify-video-or-audio-preparation-status
    """
    status: StrictStr = Field(..., description="The preparation status. One of:  `processing`: Preparing to get content. `succeeded`: Ready to get the content. You can get the content sent by users. `failed`: Failed to prepare to get the content. ")

    __properties = ["status"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('processing', 'succeeded', 'failed'):
            raise ValueError("must be one of enum values ('processing', 'succeeded', 'failed')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetMessageContentTranscodingResponse:
        """Create an instance of GetMessageContentTranscodingResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetMessageContentTranscodingResponse:
        """Create an instance of GetMessageContentTranscodingResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetMessageContentTranscodingResponse.parse_obj(obj)

        _obj = GetMessageContentTranscodingResponse.parse_obj({
            "status": obj.get("status")
        })
        return _obj

