# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import Field, StrictStr, conlist
from linebot.v3.messaging.models.imagemap_action import ImagemapAction
from linebot.v3.messaging.models.imagemap_base_size import ImagemapBaseSize
from linebot.v3.messaging.models.imagemap_video import ImagemapVideo
from linebot.v3.messaging.models.message import Message
from linebot.v3.messaging.models.quick_reply import QuickReply
from linebot.v3.messaging.models.sender import Sender

class ImagemapMessage(Message):
    """
    ImagemapMessage
    https://developers.line.biz/en/reference/messaging-api/#imagemap-message
    """
    base_url: StrictStr = Field(..., alias="baseUrl")
    alt_text: StrictStr = Field(..., alias="altText")
    base_size: ImagemapBaseSize = Field(..., alias="baseSize")
    actions: conlist(ImagemapAction) = Field(...)
    video: Optional[ImagemapVideo] = None
    type: str = "imagemap"

    __properties = ["type", "quickReply", "sender", "baseUrl", "altText", "baseSize", "actions", "video"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImagemapMessage:
        """Create an instance of ImagemapMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of quick_reply
        if self.quick_reply:
            _dict['quickReply'] = self.quick_reply.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of sender
        if self.sender:
            _dict['sender'] = self.sender.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of base_size
        if self.base_size:
            _dict['baseSize'] = self.base_size.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in actions (list)
        _items = []
        if self.actions:
            for _item in self.actions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['actions'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of video
        if self.video:
            _dict['video'] = self.video.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImagemapMessage:
        """Create an instance of ImagemapMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ImagemapMessage.parse_obj(obj)

        _obj = ImagemapMessage.parse_obj({
            "type": obj.get("type"),
            "quick_reply": QuickReply.from_dict(obj.get("quickReply")) if obj.get("quickReply") is not None else None,
            "sender": Sender.from_dict(obj.get("sender")) if obj.get("sender") is not None else None,
            "base_url": obj.get("baseUrl"),
            "alt_text": obj.get("altText"),
            "base_size": ImagemapBaseSize.from_dict(obj.get("baseSize")) if obj.get("baseSize") is not None else None,
            "actions": [ImagemapAction.from_dict(_item) for _item in obj.get("actions")] if obj.get("actions") is not None else None,
            "video": ImagemapVideo.from_dict(obj.get("video")) if obj.get("video") is not None else None
        })
        return _obj

