# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, conint

class Limit(BaseModel):
    """
    Limit of the Narrowcast
    https://developers.line.biz/en/reference/messaging-api/#send-narrowcast-message
    """
    max: Optional[conint(strict=True, ge=1)] = Field(None, description="The maximum number of narrowcast messages to send. Use this parameter to limit the number of narrowcast messages sent. The recipients will be chosen at random. ")
    up_to_remaining_quota: Optional[StrictBool] = Field(False, alias="upToRemainingQuota", description="If true, the message will be sent within the maximum number of deliverable messages. The default value is `false`.  Targets will be selected at random. ")

    __properties = ["max", "upToRemainingQuota"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Limit:
        """Create an instance of Limit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Limit:
        """Create an instance of Limit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Limit.parse_obj(obj)

        _obj = Limit.parse_obj({
            "max": obj.get("max"),
            "up_to_remaining_quota": obj.get("upToRemainingQuota") if obj.get("upToRemainingQuota") is not None else False
        })
        return _obj

