# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist, validator

class Membership(BaseModel):
    """
    Membership
    """
    membership_id: StrictInt = Field(..., alias="membershipId", description="Membership plan ID.")
    title: StrictStr = Field(..., description="Membership plan name.")
    description: StrictStr = Field(..., description="Membership plan description.")
    benefits: conlist(StrictStr, min_items=1) = Field(..., description="List of membership plan perks.")
    price: Union[StrictFloat, StrictInt] = Field(..., description="Monthly fee for membership plan. (e.g. 1500.00)")
    currency: StrictStr = Field(..., description="The currency of membership.price.")
    member_count: StrictInt = Field(..., alias="memberCount", description="Number of members subscribed to the membership plan.")
    member_limit: Optional[StrictInt] = Field(..., alias="memberLimit", description="The upper limit of members who can subscribe. If no upper limit is set, it will be null.")
    is_in_app_purchase: StrictBool = Field(..., alias="isInAppPurchase", description="Payment method for users who subscribe to a membership plan.")
    is_published: StrictBool = Field(..., alias="isPublished", description="Membership plan status.")

    __properties = ["membershipId", "title", "description", "benefits", "price", "currency", "memberCount", "memberLimit", "isInAppPurchase", "isPublished"]

    @validator('currency')
    def currency_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('JPY', 'TWD', 'THB'):
            raise ValueError("must be one of enum values ('JPY', 'TWD', 'THB')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Membership:
        """Create an instance of Membership from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if member_limit (nullable) is None
        # and __fields_set__ contains the field
        if self.member_limit is None and "member_limit" in self.__fields_set__:
            _dict['memberLimit'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Membership:
        """Create an instance of Membership from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Membership.parse_obj(obj)

        _obj = Membership.parse_obj({
            "membership_id": obj.get("membershipId"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "benefits": obj.get("benefits"),
            "price": obj.get("price"),
            "currency": obj.get("currency"),
            "member_count": obj.get("memberCount"),
            "member_limit": obj.get("memberLimit"),
            "is_in_app_purchase": obj.get("isInAppPurchase"),
            "is_published": obj.get("isPublished")
        })
        return _obj

