# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt
from linebot.v3.messaging.models.quota_type import QuotaType

class MessageQuotaResponse(BaseModel):
    """
    MessageQuotaResponse
    https://developers.line.biz/en/reference/messaging-api/#get-quota
    """
    type: QuotaType = Field(...)
    value: Optional[StrictInt] = Field(None, description="The target limit for sending messages in the current month. This property is returned when the `type` property has a value of `limited`. ")

    __properties = ["type", "value"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageQuotaResponse:
        """Create an instance of MessageQuotaResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MessageQuotaResponse:
        """Create an instance of MessageQuotaResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MessageQuotaResponse.parse_obj(obj)

        _obj = MessageQuotaResponse.parse_obj({
            "type": obj.get("type"),
            "value": obj.get("value")
        })
        return _obj

