# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, validator

class NarrowcastProgressResponse(BaseModel):
    """
    NarrowcastProgressResponse
    https://developers.line.biz/en/reference/messaging-api/#get-narrowcast-progress-status
    """
    phase: StrictStr = Field(..., description="The current status. One of:  `waiting`: Messages are not yet ready to be sent. They are currently being filtered or processed in some way. `sending`: Messages are currently being sent. `succeeded`: Messages were sent successfully. This may not mean the messages were successfully received. `failed`: Messages failed to be sent. Use the failedDescription property to find the cause of the failure. ")
    success_count: Optional[StrictInt] = Field(None, alias="successCount", description="The number of users who successfully received the message.")
    failure_count: Optional[StrictInt] = Field(None, alias="failureCount", description="The number of users who failed to send the message.")
    target_count: Optional[StrictInt] = Field(None, alias="targetCount", description="The number of intended recipients of the message.")
    failed_description: Optional[StrictStr] = Field(None, alias="failedDescription", description="The reason the message failed to be sent. This is only included with a `phase` property value of `failed`.")
    error_code: Optional[StrictInt] = Field(None, alias="errorCode", description="Error summary. This is only included with a phase property value of failed. One of:  `1`: An internal error occurred. `2`: An error occurred because there weren't enough recipients. `3`: A conflict error of requests occurs because a request that has already been accepted is retried. ")
    accepted_time: datetime = Field(..., alias="acceptedTime", description="Narrowcast message request accepted time in milliseconds.  Format: ISO 8601 (e.g. 2020-12-03T10:15:30.121Z) Timezone: UTC ")
    completed_time: Optional[datetime] = Field(None, alias="completedTime", description="Processing of narrowcast message request completion time in milliseconds. Returned when the phase property is succeeded or failed.  Format: ISO 8601 (e.g. 2020-12-03T10:15:30.121Z) Timezone: UTC ")

    __properties = ["phase", "successCount", "failureCount", "targetCount", "failedDescription", "errorCode", "acceptedTime", "completedTime"]

    @validator('phase')
    def phase_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('waiting', 'sending', 'succeeded', 'failed'):
            raise ValueError("must be one of enum values ('waiting', 'sending', 'succeeded', 'failed')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NarrowcastProgressResponse:
        """Create an instance of NarrowcastProgressResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NarrowcastProgressResponse:
        """Create an instance of NarrowcastProgressResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return NarrowcastProgressResponse.parse_obj(obj)

        _obj = NarrowcastProgressResponse.parse_obj({
            "phase": obj.get("phase"),
            "success_count": obj.get("successCount"),
            "failure_count": obj.get("failureCount"),
            "target_count": obj.get("targetCount"),
            "failed_description": obj.get("failedDescription"),
            "error_code": obj.get("errorCode"),
            "accepted_time": obj.get("acceptedTime"),
            "completed_time": obj.get("completedTime")
        })
        return _obj

