# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import Field, StrictStr, constr, validator
from linebot.v3.messaging.models.action import Action

class PostbackAction(Action):
    """
    PostbackAction
    """
    data: Optional[constr(strict=True, max_length=300, min_length=0)] = None
    display_text: Optional[StrictStr] = Field(None, alias="displayText")
    text: Optional[StrictStr] = None
    input_option: Optional[StrictStr] = Field(None, alias="inputOption")
    fill_in_text: Optional[StrictStr] = Field(None, alias="fillInText")
    type: str = "postback"

    __properties = ["type", "label", "data", "displayText", "text", "inputOption", "fillInText"]

    @validator('input_option')
    def input_option_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('closeRichMenu', 'openRichMenu', 'openKeyboard', 'openVoice'):
            raise ValueError("must be one of enum values ('closeRichMenu', 'openRichMenu', 'openKeyboard', 'openVoice')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PostbackAction:
        """Create an instance of PostbackAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PostbackAction:
        """Create an instance of PostbackAction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PostbackAction.parse_obj(obj)

        _obj = PostbackAction.parse_obj({
            "type": obj.get("type"),
            "label": obj.get("label"),
            "data": obj.get("data"),
            "display_text": obj.get("displayText"),
            "text": obj.get("text"),
            "input_option": obj.get("inputOption"),
            "fill_in_text": obj.get("fillInText")
        })
        return _obj

