# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic.v1 import BaseModel, Field
from linebot.v3.messaging.models.rich_menu_batch_progress_phase import RichMenuBatchProgressPhase

class RichMenuBatchProgressResponse(BaseModel):
    """
    RichMenuBatchProgressResponse
    https://developers.line.biz/en/reference/messaging-api/#get-batch-control-rich-menus-progress-status-response
    """
    phase: RichMenuBatchProgressPhase = Field(...)
    accepted_time: datetime = Field(..., alias="acceptedTime", description="The accepted time in milliseconds of the request of batch control the rich menu.  Format: ISO 8601 (e.g. 2023-06-08T10:15:30.121Z) Timezone: UTC ")
    completed_time: Optional[datetime] = Field(None, alias="completedTime", description="The completed time in milliseconds of rich menu batch control. Returned when the phase property is succeeded or failed.  Format: ISO 8601 (e.g. 2023-06-08T10:15:30.121Z) Timezone: UTC ")

    __properties = ["phase", "acceptedTime", "completedTime"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RichMenuBatchProgressResponse:
        """Create an instance of RichMenuBatchProgressResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RichMenuBatchProgressResponse:
        """Create an instance of RichMenuBatchProgressResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RichMenuBatchProgressResponse.parse_obj(obj)

        _obj = RichMenuBatchProgressResponse.parse_obj({
            "phase": obj.get("phase"),
            "accepted_time": obj.get("acceptedTime"),
            "completed_time": obj.get("completedTime")
        })
        return _obj

