# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, conlist, constr, validator
from linebot.v3.messaging.models.rich_menu_batch_operation import RichMenuBatchOperation

class RichMenuBatchRequest(BaseModel):
    """
    RichMenuBatchRequest
    """
    operations: conlist(RichMenuBatchOperation, max_items=1000) = Field(..., description="Array of Rich menu operation object...")
    resume_request_key: Optional[constr(strict=True, max_length=100, min_length=1)] = Field(None, alias="resumeRequestKey", description="Key for retry. Key value is a string matching the regular expression pattern")

    __properties = ["operations", "resumeRequestKey"]

    @validator('resume_request_key')
    def resume_request_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9_-]{1,100}$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9_-]{1,100}$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RichMenuBatchRequest:
        """Create an instance of RichMenuBatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in operations (list)
        _items = []
        if self.operations:
            for _item in self.operations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['operations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RichMenuBatchRequest:
        """Create an instance of RichMenuBatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RichMenuBatchRequest.parse_obj(obj)

        _obj = RichMenuBatchRequest.parse_obj({
            "operations": [RichMenuBatchOperation.from_dict(_item) for _item in obj.get("operations")] if obj.get("operations") is not None else None,
            "resume_request_key": obj.get("resumeRequestKey")
        })
        return _obj

