# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr

class SubscribedMembershipUser(BaseModel):
    """
    Object containing user membership subscription information.
    """
    membership_no: StrictInt = Field(..., alias="membershipNo", description="The user's member number in the membership plan.")
    joined_time: StrictInt = Field(..., alias="joinedTime", description="UNIX timestamp at which the user subscribed to the membership.")
    next_billing_date: StrictStr = Field(..., alias="nextBillingDate", description="Next payment date for membership plan. - Format: yyyy-MM-dd (e.g. 2024-02-08) - Timezone: UTC+9 ")
    total_subscription_months: StrictInt = Field(..., alias="totalSubscriptionMonths", description="The period of time in months that the user has been subscribed to a membership plan. If a user previously canceled and then re-subscribed to the same membership plan, only the period after the re-subscription will be counted.")

    __properties = ["membershipNo", "joinedTime", "nextBillingDate", "totalSubscriptionMonths"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SubscribedMembershipUser:
        """Create an instance of SubscribedMembershipUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SubscribedMembershipUser:
        """Create an instance of SubscribedMembershipUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SubscribedMembershipUser.parse_obj(obj)

        _obj = SubscribedMembershipUser.parse_obj({
            "membership_no": obj.get("membershipNo"),
            "joined_time": obj.get("joinedTime"),
            "next_billing_date": obj.get("nextBillingDate"),
            "total_subscription_months": obj.get("totalSubscriptionMonths")
        })
        return _obj

