# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field
from linebot.v3.messaging.models.subscribed_membership_plan import SubscribedMembershipPlan
from linebot.v3.messaging.models.subscribed_membership_user import SubscribedMembershipUser

class Subscription(BaseModel):
    """
    An array of memberships.
    """
    membership: SubscribedMembershipPlan = Field(...)
    user: SubscribedMembershipUser = Field(...)

    __properties = ["membership", "user"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Subscription:
        """Create an instance of Subscription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of membership
        if self.membership:
            _dict['membership'] = self.membership.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Subscription:
        """Create an instance of Subscription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Subscription.parse_obj(obj)

        _obj = Subscription.parse_obj({
            "membership": SubscribedMembershipPlan.from_dict(obj.get("membership")) if obj.get("membership") is not None else None,
            "user": SubscribedMembershipUser.from_dict(obj.get("user")) if obj.get("user") is not None else None
        })
        return _obj

