# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr

class TestWebhookEndpointResponse(BaseModel):
    """
    TestWebhookEndpointResponse
    https://developers.line.biz/en/reference/messaging-api/#test-webhook-endpoint
    """
    success: Optional[StrictBool] = Field(None, description="Result of the communication from the LINE platform to the webhook URL.")
    timestamp: datetime = Field(..., description="Time of the event in milliseconds. Even in the case of a redelivered webhook, it represents the time the event occurred, not the time it was redelivered. ")
    status_code: StrictInt = Field(..., alias="statusCode", description="The HTTP status code. If the webhook response isn't received, the status code is set to zero or a negative number.")
    reason: StrictStr = Field(..., description="Reason for the response.")
    detail: StrictStr = Field(..., description="Details of the response.")

    __properties = ["success", "timestamp", "statusCode", "reason", "detail"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestWebhookEndpointResponse:
        """Create an instance of TestWebhookEndpointResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestWebhookEndpointResponse:
        """Create an instance of TestWebhookEndpointResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestWebhookEndpointResponse.parse_obj(obj)

        _obj = TestWebhookEndpointResponse.parse_obj({
            "success": obj.get("success"),
            "timestamp": obj.get("timestamp"),
            "status_code": obj.get("statusCode"),
            "reason": obj.get("reason"),
            "detail": obj.get("detail")
        })
        return _obj

