# coding: utf-8

"""
    Channel Access Token API

    This document describes Channel Access Token API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io

from pydantic.v1 import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic.v1 import Field, StrictStr

from typing import Optional

from linebot.v3.oauth.models.channel_access_token_key_ids_response import ChannelAccessTokenKeyIdsResponse
from linebot.v3.oauth.models.issue_channel_access_token_response import IssueChannelAccessTokenResponse
from linebot.v3.oauth.models.issue_short_lived_channel_access_token_response import IssueShortLivedChannelAccessTokenResponse
from linebot.v3.oauth.models.issue_stateless_channel_access_token_response import IssueStatelessChannelAccessTokenResponse
from linebot.v3.oauth.models.verify_channel_access_token_response import VerifyChannelAccessTokenResponse

from linebot.v3.oauth.api_client import ApiClient
from linebot.v3.oauth.api_response import ApiResponse
from linebot.v3.oauth.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ChannelAccessToken(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client
        self.line_base_path = "https://api.line.me"


    @validate_arguments
    def gets_all_valid_channel_access_token_key_ids(self, client_assertion_type : Annotated[StrictStr, Field(..., description="`urn:ietf:params:oauth:client-assertion-type:jwt-bearer`")], client_assertion : Annotated[StrictStr, Field(..., description="A JSON Web Token (JWT) (opens new window)the client needs to create and sign with the private key.")], **kwargs) -> ChannelAccessTokenKeyIdsResponse:  # noqa: E501
        """gets_all_valid_channel_access_token_key_ids  # noqa: E501

        Gets all valid channel access token key IDs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gets_all_valid_channel_access_token_key_ids(client_assertion_type, client_assertion, async_req=True)
        >>> result = thread.get()

        :param client_assertion_type: `urn:ietf:params:oauth:client-assertion-type:jwt-bearer` (required)
        :type client_assertion_type: str
        :param client_assertion: A JSON Web Token (JWT) (opens new window)the client needs to create and sign with the private key. (required)
        :type client_assertion: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ChannelAccessTokenKeyIdsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the gets_all_valid_channel_access_token_key_ids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.gets_all_valid_channel_access_token_key_ids_with_http_info(client_assertion_type, client_assertion, **kwargs)  # noqa: E501

    @validate_arguments
    def gets_all_valid_channel_access_token_key_ids_with_http_info(self, client_assertion_type : Annotated[StrictStr, Field(..., description="`urn:ietf:params:oauth:client-assertion-type:jwt-bearer`")], client_assertion : Annotated[StrictStr, Field(..., description="A JSON Web Token (JWT) (opens new window)the client needs to create and sign with the private key.")], **kwargs) -> ApiResponse:  # noqa: E501
        """gets_all_valid_channel_access_token_key_ids  # noqa: E501

        Gets all valid channel access token key IDs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gets_all_valid_channel_access_token_key_ids_with_http_info(client_assertion_type, client_assertion, async_req=True)
        >>> result = thread.get()

        :param client_assertion_type: `urn:ietf:params:oauth:client-assertion-type:jwt-bearer` (required)
        :type client_assertion_type: str
        :param client_assertion: A JSON Web Token (JWT) (opens new window)the client needs to create and sign with the private key. (required)
        :type client_assertion: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ChannelAccessTokenKeyIdsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'client_assertion_type',
            'client_assertion'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gets_all_valid_channel_access_token_key_ids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('client_assertion_type') is not None:  # noqa: E501
            _query_params.append(('client_assertion_type', _params['client_assertion_type']))

        if _params.get('client_assertion') is not None:  # noqa: E501
            _query_params.append(('client_assertion', _params['client_assertion']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "ChannelAccessTokenKeyIdsResponse",
        }

        return self.api_client.call_api(
            '/oauth2/v2.1/tokens/kid', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def issue_channel_token(self, grant_type : Annotated[Optional[StrictStr], Field(description="`client_credentials`")] = None, client_id : Annotated[Optional[StrictStr], Field(description="Channel ID.")] = None, client_secret : Annotated[Optional[StrictStr], Field(description="Channel secret.")] = None, **kwargs) -> IssueShortLivedChannelAccessTokenResponse:  # noqa: E501
        """issue_channel_token  # noqa: E501

        Issue short-lived channel access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.issue_channel_token(grant_type, client_id, client_secret, async_req=True)
        >>> result = thread.get()

        :param grant_type: `client_credentials`
        :type grant_type: str
        :param client_id: Channel ID.
        :type client_id: str
        :param client_secret: Channel secret.
        :type client_secret: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IssueShortLivedChannelAccessTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the issue_channel_token_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.issue_channel_token_with_http_info(grant_type, client_id, client_secret, **kwargs)  # noqa: E501

    @validate_arguments
    def issue_channel_token_with_http_info(self, grant_type : Annotated[Optional[StrictStr], Field(description="`client_credentials`")] = None, client_id : Annotated[Optional[StrictStr], Field(description="Channel ID.")] = None, client_secret : Annotated[Optional[StrictStr], Field(description="Channel secret.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """issue_channel_token  # noqa: E501

        Issue short-lived channel access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.issue_channel_token_with_http_info(grant_type, client_id, client_secret, async_req=True)
        >>> result = thread.get()

        :param grant_type: `client_credentials`
        :type grant_type: str
        :param client_id: Channel ID.
        :type client_id: str
        :param client_secret: Channel secret.
        :type client_secret: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IssueShortLivedChannelAccessTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'grant_type',
            'client_id',
            'client_secret'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issue_channel_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['grant_type']:
            _form_params.append(('grant_type', _params['grant_type']))

        if _params['client_id']:
            _form_params.append(('client_id', _params['client_id']))

        if _params['client_secret']:
            _form_params.append(('client_secret', _params['client_secret']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/x-www-form-urlencoded']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "IssueShortLivedChannelAccessTokenResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v2/oauth/accessToken', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def issue_channel_token_by_jwt(self, grant_type : Annotated[Optional[StrictStr], Field(description="client_credentials")] = None, client_assertion_type : Annotated[Optional[StrictStr], Field(description="urn:ietf:params:oauth:client-assertion-type:jwt-bearer")] = None, client_assertion : Annotated[Optional[StrictStr], Field(description="A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.")] = None, **kwargs) -> IssueChannelAccessTokenResponse:  # noqa: E501
        """issue_channel_token_by_jwt  # noqa: E501

        Issues a channel access token that allows you to specify a desired expiration date. This method lets you use JWT assertion for authentication.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.issue_channel_token_by_jwt(grant_type, client_assertion_type, client_assertion, async_req=True)
        >>> result = thread.get()

        :param grant_type: client_credentials
        :type grant_type: str
        :param client_assertion_type: urn:ietf:params:oauth:client-assertion-type:jwt-bearer
        :type client_assertion_type: str
        :param client_assertion: A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
        :type client_assertion: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IssueChannelAccessTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the issue_channel_token_by_jwt_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.issue_channel_token_by_jwt_with_http_info(grant_type, client_assertion_type, client_assertion, **kwargs)  # noqa: E501

    @validate_arguments
    def issue_channel_token_by_jwt_with_http_info(self, grant_type : Annotated[Optional[StrictStr], Field(description="client_credentials")] = None, client_assertion_type : Annotated[Optional[StrictStr], Field(description="urn:ietf:params:oauth:client-assertion-type:jwt-bearer")] = None, client_assertion : Annotated[Optional[StrictStr], Field(description="A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """issue_channel_token_by_jwt  # noqa: E501

        Issues a channel access token that allows you to specify a desired expiration date. This method lets you use JWT assertion for authentication.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.issue_channel_token_by_jwt_with_http_info(grant_type, client_assertion_type, client_assertion, async_req=True)
        >>> result = thread.get()

        :param grant_type: client_credentials
        :type grant_type: str
        :param client_assertion_type: urn:ietf:params:oauth:client-assertion-type:jwt-bearer
        :type client_assertion_type: str
        :param client_assertion: A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
        :type client_assertion: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IssueChannelAccessTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'grant_type',
            'client_assertion_type',
            'client_assertion'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issue_channel_token_by_jwt" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['grant_type']:
            _form_params.append(('grant_type', _params['grant_type']))

        if _params['client_assertion_type']:
            _form_params.append(('client_assertion_type', _params['client_assertion_type']))

        if _params['client_assertion']:
            _form_params.append(('client_assertion', _params['client_assertion']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/x-www-form-urlencoded']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "IssueChannelAccessTokenResponse",
        }

        return self.api_client.call_api(
            '/oauth2/v2.1/token', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def issue_stateless_channel_token(self, grant_type : Annotated[StrictStr, Field(..., description="`client_credentials`")], client_assertion_type : Annotated[StrictStr, Field(..., description="URL-encoded value of `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`")], client_assertion : Annotated[StrictStr, Field(..., description="A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.")], client_id : Annotated[StrictStr, Field(..., description="Channel ID.")], client_secret : Annotated[StrictStr, Field(..., description="Channel secret.")], **kwargs) -> IssueStatelessChannelAccessTokenResponse:  # noqa: E501
        """issue_stateless_channel_token  # noqa: E501

        Issues a new stateless channel access token, which doesn't have max active token limit unlike the other token types. The newly issued token is only valid for 15 minutes but can not be revoked until it naturally expires.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.issue_stateless_channel_token(grant_type, client_assertion_type, client_assertion, client_id, client_secret, async_req=True)
        >>> result = thread.get()

        :param grant_type: `client_credentials` (required)
        :type grant_type: str
        :param client_assertion_type: URL-encoded value of `urn:ietf:params:oauth:client-assertion-type:jwt-bearer` (required)
        :type client_assertion_type: str
        :param client_assertion: A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key. (required)
        :type client_assertion: str
        :param client_id: Channel ID. (required)
        :type client_id: str
        :param client_secret: Channel secret. (required)
        :type client_secret: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IssueStatelessChannelAccessTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the issue_stateless_channel_token_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.issue_stateless_channel_token_with_http_info(grant_type, client_assertion_type, client_assertion, client_id, client_secret, **kwargs)  # noqa: E501

    @validate_arguments
    def issue_stateless_channel_token_with_http_info(self, grant_type : Annotated[StrictStr, Field(..., description="`client_credentials`")], client_assertion_type : Annotated[StrictStr, Field(..., description="URL-encoded value of `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`")], client_assertion : Annotated[StrictStr, Field(..., description="A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.")], client_id : Annotated[StrictStr, Field(..., description="Channel ID.")], client_secret : Annotated[StrictStr, Field(..., description="Channel secret.")], **kwargs) -> ApiResponse:  # noqa: E501
        """issue_stateless_channel_token  # noqa: E501

        Issues a new stateless channel access token, which doesn't have max active token limit unlike the other token types. The newly issued token is only valid for 15 minutes but can not be revoked until it naturally expires.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.issue_stateless_channel_token_with_http_info(grant_type, client_assertion_type, client_assertion, client_id, client_secret, async_req=True)
        >>> result = thread.get()

        :param grant_type: `client_credentials` (required)
        :type grant_type: str
        :param client_assertion_type: URL-encoded value of `urn:ietf:params:oauth:client-assertion-type:jwt-bearer` (required)
        :type client_assertion_type: str
        :param client_assertion: A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key. (required)
        :type client_assertion: str
        :param client_id: Channel ID. (required)
        :type client_id: str
        :param client_secret: Channel secret. (required)
        :type client_secret: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IssueStatelessChannelAccessTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'grant_type',
            'client_assertion_type',
            'client_assertion',
            'client_id',
            'client_secret'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issue_stateless_channel_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['grant_type']:
            _form_params.append(('grant_type', _params['grant_type']))

        if _params['client_assertion_type']:
            _form_params.append(('client_assertion_type', _params['client_assertion_type']))

        if _params['client_assertion']:
            _form_params.append(('client_assertion', _params['client_assertion']))

        if _params['client_id']:
            _form_params.append(('client_id', _params['client_id']))

        if _params['client_secret']:
            _form_params.append(('client_secret', _params['client_secret']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/x-www-form-urlencoded']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "IssueStatelessChannelAccessTokenResponse",
        }

        return self.api_client.call_api(
            '/oauth2/v3/token', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def revoke_channel_token(self, access_token : Annotated[Optional[StrictStr], Field(description="Channel access token")] = None, **kwargs) -> None:  # noqa: E501
        """revoke_channel_token  # noqa: E501

        Revoke short-lived or long-lived channel access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.revoke_channel_token(access_token, async_req=True)
        >>> result = thread.get()

        :param access_token: Channel access token
        :type access_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the revoke_channel_token_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.revoke_channel_token_with_http_info(access_token, **kwargs)  # noqa: E501

    @validate_arguments
    def revoke_channel_token_with_http_info(self, access_token : Annotated[Optional[StrictStr], Field(description="Channel access token")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """revoke_channel_token  # noqa: E501

        Revoke short-lived or long-lived channel access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.revoke_channel_token_with_http_info(access_token, async_req=True)
        >>> result = thread.get()

        :param access_token: Channel access token
        :type access_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'access_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_channel_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['access_token']:
            _form_params.append(('access_token', _params['access_token']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/x-www-form-urlencoded']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v2/oauth/revoke', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def revoke_channel_token_by_jwt(self, client_id : Annotated[Optional[StrictStr], Field(description="Channel ID")] = None, client_secret : Annotated[Optional[StrictStr], Field(description="Channel Secret")] = None, access_token : Annotated[Optional[StrictStr], Field(description="Channel access token")] = None, **kwargs) -> None:  # noqa: E501
        """revoke_channel_token_by_jwt  # noqa: E501

        Revoke channel access token v2.1  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.revoke_channel_token_by_jwt(client_id, client_secret, access_token, async_req=True)
        >>> result = thread.get()

        :param client_id: Channel ID
        :type client_id: str
        :param client_secret: Channel Secret
        :type client_secret: str
        :param access_token: Channel access token
        :type access_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the revoke_channel_token_by_jwt_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.revoke_channel_token_by_jwt_with_http_info(client_id, client_secret, access_token, **kwargs)  # noqa: E501

    @validate_arguments
    def revoke_channel_token_by_jwt_with_http_info(self, client_id : Annotated[Optional[StrictStr], Field(description="Channel ID")] = None, client_secret : Annotated[Optional[StrictStr], Field(description="Channel Secret")] = None, access_token : Annotated[Optional[StrictStr], Field(description="Channel access token")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """revoke_channel_token_by_jwt  # noqa: E501

        Revoke channel access token v2.1  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.revoke_channel_token_by_jwt_with_http_info(client_id, client_secret, access_token, async_req=True)
        >>> result = thread.get()

        :param client_id: Channel ID
        :type client_id: str
        :param client_secret: Channel Secret
        :type client_secret: str
        :param access_token: Channel access token
        :type access_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'client_id',
            'client_secret',
            'access_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_channel_token_by_jwt" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['client_id']:
            _form_params.append(('client_id', _params['client_id']))

        if _params['client_secret']:
            _form_params.append(('client_secret', _params['client_secret']))

        if _params['access_token']:
            _form_params.append(('access_token', _params['access_token']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/x-www-form-urlencoded']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/oauth2/v2.1/revoke', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def verify_channel_token(self, access_token : Annotated[Optional[StrictStr], Field(description="A short-lived or long-lived channel access token.")] = None, **kwargs) -> VerifyChannelAccessTokenResponse:  # noqa: E501
        """verify_channel_token  # noqa: E501

        Verify the validity of short-lived and long-lived channel access tokens  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_channel_token(access_token, async_req=True)
        >>> result = thread.get()

        :param access_token: A short-lived or long-lived channel access token.
        :type access_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VerifyChannelAccessTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the verify_channel_token_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.verify_channel_token_with_http_info(access_token, **kwargs)  # noqa: E501

    @validate_arguments
    def verify_channel_token_with_http_info(self, access_token : Annotated[Optional[StrictStr], Field(description="A short-lived or long-lived channel access token.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """verify_channel_token  # noqa: E501

        Verify the validity of short-lived and long-lived channel access tokens  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_channel_token_with_http_info(access_token, async_req=True)
        >>> result = thread.get()

        :param access_token: A short-lived or long-lived channel access token.
        :type access_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VerifyChannelAccessTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'access_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_channel_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['access_token']:
            _form_params.append(('access_token', _params['access_token']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/x-www-form-urlencoded']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "VerifyChannelAccessTokenResponse",
        }

        return self.api_client.call_api(
            '/v2/oauth/verify', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def verify_channel_token_by_jwt(self, access_token : Annotated[StrictStr, Field(..., description="Channel access token with a user-specified expiration (Channel Access Token v2.1).")], **kwargs) -> VerifyChannelAccessTokenResponse:  # noqa: E501
        """verify_channel_token_by_jwt  # noqa: E501

        You can verify whether a Channel access token with a user-specified expiration (Channel Access Token v2.1) is valid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_channel_token_by_jwt(access_token, async_req=True)
        >>> result = thread.get()

        :param access_token: Channel access token with a user-specified expiration (Channel Access Token v2.1). (required)
        :type access_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VerifyChannelAccessTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the verify_channel_token_by_jwt_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.verify_channel_token_by_jwt_with_http_info(access_token, **kwargs)  # noqa: E501

    @validate_arguments
    def verify_channel_token_by_jwt_with_http_info(self, access_token : Annotated[StrictStr, Field(..., description="Channel access token with a user-specified expiration (Channel Access Token v2.1).")], **kwargs) -> ApiResponse:  # noqa: E501
        """verify_channel_token_by_jwt  # noqa: E501

        You can verify whether a Channel access token with a user-specified expiration (Channel Access Token v2.1) is valid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_channel_token_by_jwt_with_http_info(access_token, async_req=True)
        >>> result = thread.get()

        :param access_token: Channel access token with a user-specified expiration (Channel Access Token v2.1). (required)
        :type access_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VerifyChannelAccessTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'access_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_channel_token_by_jwt" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('access_token') is not None:  # noqa: E501
            _query_params.append(('access_token', _params['access_token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "VerifyChannelAccessTokenResponse",
        }

        return self.api_client.call_api(
            '/oauth2/v2.1/verify', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
