# coding: utf-8

"""
    Channel Access Token API

    This document describes Channel Access Token API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr

class IssueChannelAccessTokenResponse(BaseModel):
    """
    Issued channel access token
    https://developers.line.biz/en/reference/messaging-api/#issue-channel-access-token-v2-1
    """
    access_token: StrictStr = Field(..., description="Channel access token. ")
    expires_in: StrictInt = Field(..., description="Amount of time in seconds from issue to expiration of the channel access token")
    token_type: StrictStr = Field(..., description="A token type.")
    key_id: StrictStr = Field(..., description="Unique key ID for identifying the channel access token.")

    __properties = ["access_token", "expires_in", "token_type", "key_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IssueChannelAccessTokenResponse:
        """Create an instance of IssueChannelAccessTokenResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IssueChannelAccessTokenResponse:
        """Create an instance of IssueChannelAccessTokenResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IssueChannelAccessTokenResponse.parse_obj(obj)

        _obj = IssueChannelAccessTokenResponse.parse_obj({
            "access_token": obj.get("access_token"),
            "expires_in": obj.get("expires_in"),
            "token_type": obj.get("token_type") if obj.get("token_type") is not None else 'Bearer',
            "key_id": obj.get("key_id")
        })
        return _obj

