# coding: utf-8

"""
    Channel Access Token API

    This document describes Channel Access Token API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr

class IssueShortLivedChannelAccessTokenResponse(BaseModel):
    """
    Issued short-lived channel access token
    https://developers.line.biz/en/reference/messaging-api/#issue-shortlived-channel-access-token
    """
    access_token: StrictStr = Field(..., description="A short-lived channel access token. Valid for 30 days. Note: Channel access tokens cannot be refreshed. ")
    expires_in: StrictInt = Field(..., description="Time until channel access token expires in seconds from time the token is issued.")
    token_type: StrictStr = Field(..., description="Token type. The value is always `Bearer`.")

    __properties = ["access_token", "expires_in", "token_type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IssueShortLivedChannelAccessTokenResponse:
        """Create an instance of IssueShortLivedChannelAccessTokenResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IssueShortLivedChannelAccessTokenResponse:
        """Create an instance of IssueShortLivedChannelAccessTokenResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IssueShortLivedChannelAccessTokenResponse.parse_obj(obj)

        _obj = IssueShortLivedChannelAccessTokenResponse.parse_obj({
            "access_token": obj.get("access_token"),
            "expires_in": obj.get("expires_in"),
            "token_type": obj.get("token_type") if obj.get("token_type") is not None else 'Bearer'
        })
        return _obj

