# coding: utf-8

"""
    Mission Stickers API

    This document describes LINE Mission Stickers API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr

class MissionStickerRequest(BaseModel):
    """
    Send mission stickers (v3)
    https://developers.line.biz/en/reference/partner-docs/#send-mission-stickers-v3
    """
    to: StrictStr = Field(..., description="Destination user ID")
    product_id: StrictStr = Field(..., alias="productId", description="Package ID for a set of stickers")
    product_type: StrictStr = Field(..., alias="productType", description="`STICKER`")
    send_present_message: StrictBool = Field(..., alias="sendPresentMessage", description="`false`")

    __properties = ["to", "productId", "productType", "sendPresentMessage"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MissionStickerRequest:
        """Create an instance of MissionStickerRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MissionStickerRequest:
        """Create an instance of MissionStickerRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MissionStickerRequest.parse_obj(obj)

        _obj = MissionStickerRequest.parse_obj({
            "to": obj.get("to"),
            "product_id": obj.get("productId"),
            "product_type": obj.get("productType"),
            "send_present_message": obj.get("sendPresentMessage")
        })
        return _obj

