# coding: utf-8

"""
    Webhook Type Definition

    Webhook event definition of the LINE Messaging API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr, validator

class BeaconContent(BaseModel):
    """
    BeaconContent
    """
    hwid: StrictStr = Field(..., description="Hardware ID of the beacon that was detected")
    type: StrictStr = Field(..., description="Type of beacon event.")
    dm: Optional[StrictStr] = Field(None, description="Device message of beacon that was detected.")

    __properties = ["hwid", "type", "dm"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('enter', 'banner', 'stay'):
            raise ValueError("must be one of enum values ('enter', 'banner', 'stay')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BeaconContent:
        """Create an instance of BeaconContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BeaconContent:
        """Create an instance of BeaconContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BeaconContent.parse_obj(obj)

        _obj = BeaconContent.parse_obj({
            "hwid": obj.get("hwid"),
            "type": obj.get("type"),
            "dm": obj.get("dm")
        })
        return _obj

