# coding: utf-8

"""
    Webhook Type Definition

    Webhook event definition of the LINE Messaging API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr, validator

class ContentProvider(BaseModel):
    """
    Provider of the media file.
    """
    type: StrictStr = Field(..., description="Provider of the image file.")
    original_content_url: Optional[StrictStr] = Field(None, alias="originalContentUrl", description="URL of the image file. Only included when contentProvider.type is external.")
    preview_image_url: Optional[StrictStr] = Field(None, alias="previewImageUrl", description="URL of the preview image. Only included when contentProvider.type is external.")

    __properties = ["type", "originalContentUrl", "previewImageUrl"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('line', 'external'):
            raise ValueError("must be one of enum values ('line', 'external')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ContentProvider:
        """Create an instance of ContentProvider from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ContentProvider:
        """Create an instance of ContentProvider from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ContentProvider.parse_obj(obj)

        _obj = ContentProvider.parse_obj({
            "type": obj.get("type"),
            "original_content_url": obj.get("originalContentUrl"),
            "preview_image_url": obj.get("previewImageUrl")
        })
        return _obj

