# coding: utf-8

"""
    Webhook Type Definition

    Webhook event definition of the LINE Messaging API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field, StrictStr, validator

class LinkContent(BaseModel):
    """
    Content of the account link event.
    """
    result: StrictStr = Field(..., description="One of the following values to indicate whether linking the account was successful or not")
    nonce: StrictStr = Field(..., description="Specified nonce (number used once) when verifying the user ID.")

    __properties = ["result", "nonce"]

    @validator('result')
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('ok', 'failed'):
            raise ValueError("must be one of enum values ('ok', 'failed')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LinkContent:
        """Create an instance of LinkContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LinkContent:
        """Create an instance of LinkContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LinkContent.parse_obj(obj)

        _obj = LinkContent.parse_obj({
            "result": obj.get("result"),
            "nonce": obj.get("nonce")
        })
        return _obj

