# -*- coding: utf-8 -*-

#  Licensed under the Apache License, Version 2.0 (the "License"); you may
#  not use this file except in compliance with the License. You may obtain
#  a copy of the License at
#
#       https://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#  License for the specific language governing permissions and limitations
#  under the License.

"""linebot package."""


from .__about__ import (  # noqa
    __version__
)
from .api import (  # noqa
    LineBotApi,
)
from .async_api import (  # noqa
    AsyncLineBotApi,
)
from .http_client import (  # noqa
    HttpClient,
    RequestsHttpClient,
    HttpResponse,
)
from .async_http_client import (  # noqa
    AsyncHttpClient,
    AsyncHttpResponse,
)
from .webhook import (  # noqa
    SignatureValidator,
    WebhookParser,
    WebhookHandler,
    WebhookPayload,
)

from .deprecations import (
    LineBotSdkDeprecationWarning,
    LineBotSdkDeprecatedIn30,
)
