# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from linebot.v3.audience.models.audience_group_job_failed_type import AudienceGroupJobFailedType
from linebot.v3.audience.models.audience_group_job_status import AudienceGroupJobStatus
from linebot.v3.audience.models.audience_group_job_type import AudienceGroupJobType

class AudienceGroupJob(BaseModel):
    """
    Audience group job
    https://developers.line.biz/en/reference/messaging-api/#get-audience-group
    """
    audience_group_job_id: Optional[StrictInt] = Field(None, alias="audienceGroupJobId", description="A job ID.")
    audience_group_id: Optional[StrictInt] = Field(None, alias="audienceGroupId", description="An audience ID.")
    description: Optional[StrictStr] = Field(None, description="The job's description.")
    type: Optional[AudienceGroupJobType] = None
    job_status: Optional[AudienceGroupJobStatus] = Field(None, alias="jobStatus")
    failed_type: Optional[AudienceGroupJobFailedType] = Field(None, alias="failedType")
    audience_count: Optional[StrictInt] = Field(None, alias="audienceCount", description="The number of accounts (recipients) that were added or removed.")
    created: Optional[StrictInt] = Field(None, description="When the job was created (in UNIX time).")

    __properties = ["audienceGroupJobId", "audienceGroupId", "description", "type", "jobStatus", "failedType", "audienceCount", "created"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AudienceGroupJob:
        """Create an instance of AudienceGroupJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AudienceGroupJob:
        """Create an instance of AudienceGroupJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AudienceGroupJob.parse_obj(obj)

        _obj = AudienceGroupJob.parse_obj({
            "audience_group_job_id": obj.get("audienceGroupJobId"),
            "audience_group_id": obj.get("audienceGroupId"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "job_status": obj.get("jobStatus"),
            "failed_type": obj.get("failedType"),
            "audience_count": obj.get("audienceCount"),
            "created": obj.get("created")
        })
        return _obj

