# coding: utf-8

"""
    LINE Messaging API(Insight)

    This document describes LINE Messaging API(Insight).  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, conlist
from linebot.v3.insight.models.age_tile import AgeTile
from linebot.v3.insight.models.app_type_tile import AppTypeTile
from linebot.v3.insight.models.area_tile import AreaTile
from linebot.v3.insight.models.gender_tile import GenderTile
from linebot.v3.insight.models.subscription_period_tile import SubscriptionPeriodTile

class GetFriendsDemographicsResponse(BaseModel):
    """
    Get friend demographics
    https://developers.line.biz/en/reference/messaging-api/#get-demographic
    """
    available: Optional[StrictBool] = Field(None, description="true if friend demographic information is available.")
    genders: Optional[conlist(GenderTile)] = Field(None, description="Percentage per gender.")
    ages: Optional[conlist(AgeTile)] = Field(None, description="Percentage per age group.")
    areas: Optional[conlist(AreaTile)] = Field(None, description="Percentage per area.")
    app_types: Optional[conlist(AppTypeTile)] = Field(None, alias="appTypes", description="Percentage by OS.")
    subscription_periods: Optional[conlist(SubscriptionPeriodTile)] = Field(None, alias="subscriptionPeriods", description="Percentage per friendship duration.")

    __properties = ["available", "genders", "ages", "areas", "appTypes", "subscriptionPeriods"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetFriendsDemographicsResponse:
        """Create an instance of GetFriendsDemographicsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in genders (list)
        _items = []
        if self.genders:
            for _item in self.genders:
                if _item:
                    _items.append(_item.to_dict())
            _dict['genders'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in ages (list)
        _items = []
        if self.ages:
            for _item in self.ages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ages'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in areas (list)
        _items = []
        if self.areas:
            for _item in self.areas:
                if _item:
                    _items.append(_item.to_dict())
            _dict['areas'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in app_types (list)
        _items = []
        if self.app_types:
            for _item in self.app_types:
                if _item:
                    _items.append(_item.to_dict())
            _dict['appTypes'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in subscription_periods (list)
        _items = []
        if self.subscription_periods:
            for _item in self.subscription_periods:
                if _item:
                    _items.append(_item.to_dict())
            _dict['subscriptionPeriods'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetFriendsDemographicsResponse:
        """Create an instance of GetFriendsDemographicsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetFriendsDemographicsResponse.parse_obj(obj)

        _obj = GetFriendsDemographicsResponse.parse_obj({
            "available": obj.get("available"),
            "genders": [GenderTile.from_dict(_item) for _item in obj.get("genders")] if obj.get("genders") is not None else None,
            "ages": [AgeTile.from_dict(_item) for _item in obj.get("ages")] if obj.get("ages") is not None else None,
            "areas": [AreaTile.from_dict(_item) for _item in obj.get("areas")] if obj.get("areas") is not None else None,
            "app_types": [AppTypeTile.from_dict(_item) for _item in obj.get("appTypes")] if obj.get("appTypes") is not None else None,
            "subscription_periods": [SubscriptionPeriodTile.from_dict(_item) for _item in obj.get("subscriptionPeriods")] if obj.get("subscriptionPeriods") is not None else None
        })
        return _obj

