# coding: utf-8

"""
    LINE Messaging API(Insight)

    This document describes LINE Messaging API(Insight).  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, validator

class GetNumberOfFollowersResponse(BaseModel):
    """
    Get number of followers
    https://developers.line.biz/en/reference/messaging-api/#get-number-of-followers
    """
    status: Optional[StrictStr] = Field(None, description="Calculation status.")
    followers: Optional[StrictInt] = Field(None, description="The number of times, as of the specified date, that a user added this LINE Official Account as a friend for the first time. The number doesn't decrease even if a user later blocks the account or when they delete their LINE account. ")
    targeted_reaches: Optional[StrictInt] = Field(None, alias="targetedReaches", description="The number of users, as of the specified date, that the LINE Official Account can reach through targeted messages based on gender, age, and/or region. This number only includes users who are active on LINE or LINE services and whose demographics have a high level of certainty. ")
    blocks: Optional[StrictInt] = Field(None, description="The number of users blocking the account as of the specified date. The number decreases when a user unblocks the account.   ")

    __properties = ["status", "followers", "targetedReaches", "blocks"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('ready', 'unready', 'out_of_service'):
            raise ValueError("must be one of enum values ('ready', 'unready', 'out_of_service')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetNumberOfFollowersResponse:
        """Create an instance of GetNumberOfFollowersResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetNumberOfFollowersResponse:
        """Create an instance of GetNumberOfFollowersResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetNumberOfFollowersResponse.parse_obj(obj)

        _obj = GetNumberOfFollowersResponse.parse_obj({
            "status": obj.get("status"),
            "followers": obj.get("followers"),
            "targeted_reaches": obj.get("targetedReaches"),
            "blocks": obj.get("blocks")
        })
        return _obj

