# coding: utf-8

"""
    LINE Messaging API(Insight)

    This document describes LINE Messaging API(Insight).  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, validator

class GetNumberOfMessageDeliveriesResponse(BaseModel):
    """
    Get number of message deliveries
    https://developers.line.biz/en/reference/messaging-api/#get-number-of-delivery-messages
    """
    status: Optional[StrictStr] = Field(None, description="Status of the counting process.")
    broadcast: Optional[StrictInt] = Field(None, description="Number of messages sent to all of this LINE Official Account's friends (broadcast messages).")
    targeting: Optional[StrictInt] = Field(None, description="Number of messages sent to some of this LINE Official Account's friends, based on specific attributes (targeted messages).")
    auto_response: Optional[StrictInt] = Field(None, alias="autoResponse", description="Number of auto-response messages sent.")
    welcome_response: Optional[StrictInt] = Field(None, alias="welcomeResponse", description="Number of greeting messages sent.")
    chat: Optional[StrictInt] = Field(None, description="Number of messages sent from LINE Official Account Manager [Chat screen](https://www.linebiz.com/jp/manual/OfficialAccountManager/chats/) (only available in Japanese).")
    api_broadcast: Optional[StrictInt] = Field(None, alias="apiBroadcast", description="Number of broadcast messages sent with the `Send broadcast message` Messaging API operation.")
    api_push: Optional[StrictInt] = Field(None, alias="apiPush", description="Number of push messages sent with the `Send push message` Messaging API operation.")
    api_multicast: Optional[StrictInt] = Field(None, alias="apiMulticast", description="Number of multicast messages sent with the `Send multicast message` Messaging API operation.")
    api_narrowcast: Optional[StrictInt] = Field(None, alias="apiNarrowcast", description="Number of narrowcast messages sent with the `Send narrowcast message` Messaging API operation.")
    api_reply: Optional[StrictInt] = Field(None, alias="apiReply", description="Number of replies sent with the `Send reply message` Messaging API operation.")

    __properties = ["status", "broadcast", "targeting", "autoResponse", "welcomeResponse", "chat", "apiBroadcast", "apiPush", "apiMulticast", "apiNarrowcast", "apiReply"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('ready', 'unready', 'out_of_service'):
            raise ValueError("must be one of enum values ('ready', 'unready', 'out_of_service')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetNumberOfMessageDeliveriesResponse:
        """Create an instance of GetNumberOfMessageDeliveriesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetNumberOfMessageDeliveriesResponse:
        """Create an instance of GetNumberOfMessageDeliveriesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetNumberOfMessageDeliveriesResponse.parse_obj(obj)

        _obj = GetNumberOfMessageDeliveriesResponse.parse_obj({
            "status": obj.get("status"),
            "broadcast": obj.get("broadcast"),
            "targeting": obj.get("targeting"),
            "auto_response": obj.get("autoResponse"),
            "welcome_response": obj.get("welcomeResponse"),
            "chat": obj.get("chat"),
            "api_broadcast": obj.get("apiBroadcast"),
            "api_push": obj.get("apiPush"),
            "api_multicast": obj.get("apiMulticast"),
            "api_narrowcast": obj.get("apiNarrowcast"),
            "api_reply": obj.get("apiReply")
        })
        return _obj

