# coding: utf-8

"""
    LINE Messaging API(Insight)

    This document describes LINE Messaging API(Insight).  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr, validator

class SubscriptionPeriodTile(BaseModel):
    """
    SubscriptionPeriodTile
    """
    subscription_period: Optional[StrictStr] = Field(None, alias="subscriptionPeriod", description="Subscription period. Possible values: `within7days`, `within90days`, `unknown` etc.")
    percentage: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Percentage. Possible values: [0.0,100.0] e.g. 0, 2.9, 37.6.")

    __properties = ["subscriptionPeriod", "percentage"]

    @validator('subscription_period')
    def subscription_period_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('within7days', 'within30days', 'within90days', 'within180days', 'within365days', 'over365days', 'unknown'):
            raise ValueError("must be one of enum values ('within7days', 'within30days', 'within90days', 'within180days', 'within365days', 'over365days', 'unknown')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SubscriptionPeriodTile:
        """Create an instance of SubscriptionPeriodTile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SubscriptionPeriodTile:
        """Create an instance of SubscriptionPeriodTile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SubscriptionPeriodTile.parse_obj(obj)

        _obj = SubscriptionPeriodTile.parse_obj({
            "subscription_period": obj.get("subscriptionPeriod"),
            "percentage": obj.get("percentage")
        })
        return _obj

