# coding: utf-8

"""
    LIFF server API

    LIFF Server API.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool

class LiffFeatures(BaseModel):
    """
    LiffFeatures
    """
    ble: Optional[StrictBool] = Field(None, description="`true` if the LIFF app supports Bluetooth® Low Energy for LINE Things. `false` otherwise. ")
    qr_code: Optional[StrictBool] = Field(False, alias="qrCode", description="`true` to use the 2D code reader in the LIFF app. false otherwise. The default value is `false`. ")

    __properties = ["ble", "qrCode"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LiffFeatures:
        """Create an instance of LiffFeatures from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LiffFeatures:
        """Create an instance of LiffFeatures from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LiffFeatures.parse_obj(obj)

        _obj = LiffFeatures.parse_obj({
            "ble": obj.get("ble"),
            "qr_code": obj.get("qrCode") if obj.get("qrCode") is not None else False
        })
        return _obj

