# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr, validator

class BotInfoResponse(BaseModel):
    """
    BotInfoResponse
    https://developers.line.biz/en/reference/messaging-api/#get-bot-info
    """
    user_id: StrictStr = Field(..., alias="userId", description="Bot's user ID")
    basic_id: StrictStr = Field(..., alias="basicId", description="Bot's basic ID")
    premium_id: Optional[StrictStr] = Field(None, alias="premiumId", description="Bot's premium ID. Not included in the response if the premium ID isn't set.")
    display_name: StrictStr = Field(..., alias="displayName", description="Bot's display name")
    picture_url: Optional[StrictStr] = Field(None, alias="pictureUrl", description="Profile image URL. `https` image URL. Not included in the response if the bot doesn't have a profile image.")
    chat_mode: StrictStr = Field(..., alias="chatMode", description="Chat settings set in the LINE Official Account Manager. One of:  `chat`: Chat is set to \"On\". `bot`: Chat is set to \"Off\". ")
    mark_as_read_mode: StrictStr = Field(..., alias="markAsReadMode", description="Automatic read setting for messages. If the chat is set to \"Off\", auto is returned. If the chat is set to \"On\", manual is returned.  `auto`: Auto read setting is enabled. `manual`: Auto read setting is disabled.  ")

    __properties = ["userId", "basicId", "premiumId", "displayName", "pictureUrl", "chatMode", "markAsReadMode"]

    @validator('chat_mode')
    def chat_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('chat', 'bot'):
            raise ValueError("must be one of enum values ('chat', 'bot')")
        return value

    @validator('mark_as_read_mode')
    def mark_as_read_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('auto', 'manual'):
            raise ValueError("must be one of enum values ('auto', 'manual')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BotInfoResponse:
        """Create an instance of BotInfoResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BotInfoResponse:
        """Create an instance of BotInfoResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BotInfoResponse.parse_obj(obj)

        _obj = BotInfoResponse.parse_obj({
            "user_id": obj.get("userId"),
            "basic_id": obj.get("basicId"),
            "premium_id": obj.get("premiumId"),
            "display_name": obj.get("displayName"),
            "picture_url": obj.get("pictureUrl"),
            "chat_mode": obj.get("chatMode"),
            "mark_as_read_mode": obj.get("markAsReadMode")
        })
        return _obj

