# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import StrictStr, constr, validator
from linebot.v3.messaging.models.action import Action

class DatetimePickerAction(Action):
    """
    DatetimePickerAction
    https://developers.line.biz/en/reference/messaging-api/#datetime-picker-action
    """
    data: Optional[constr(strict=True, max_length=300, min_length=0)] = None
    mode: Optional[StrictStr] = None
    initial: Optional[StrictStr] = None
    max: Optional[StrictStr] = None
    min: Optional[StrictStr] = None
    type: str = "datetimepicker"

    __properties = ["type", "label", "data", "mode", "initial", "max", "min"]

    @validator('mode')
    def mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('date', 'time', 'datetime'):
            raise ValueError("must be one of enum values ('date', 'time', 'datetime')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DatetimePickerAction:
        """Create an instance of DatetimePickerAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DatetimePickerAction:
        """Create an instance of DatetimePickerAction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DatetimePickerAction.parse_obj(obj)

        _obj = DatetimePickerAction.parse_obj({
            "type": obj.get("type"),
            "label": obj.get("label"),
            "data": obj.get("data"),
            "mode": obj.get("mode"),
            "initial": obj.get("initial"),
            "max": obj.get("max"),
            "min": obj.get("min")
        })
        return _obj

