# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import StrictStr, validator
from linebot.v3.messaging.models.action import Action
from linebot.v3.messaging.models.flex_box import FlexBox
from linebot.v3.messaging.models.flex_bubble_styles import FlexBubbleStyles
from linebot.v3.messaging.models.flex_component import FlexComponent
from linebot.v3.messaging.models.flex_container import FlexContainer

class FlexBubble(FlexContainer):
    """
    FlexBubble
    """
    direction: Optional[StrictStr] = None
    styles: Optional[FlexBubbleStyles] = None
    header: Optional[FlexBox] = None
    hero: Optional[FlexComponent] = None
    body: Optional[FlexBox] = None
    footer: Optional[FlexBox] = None
    size: Optional[StrictStr] = None
    action: Optional[Action] = None
    type: str = "bubble"

    __properties = ["type", "direction", "styles", "header", "hero", "body", "footer", "size", "action"]

    @validator('direction')
    def direction_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('ltr', 'rtl'):
            raise ValueError("must be one of enum values ('ltr', 'rtl')")
        return value

    @validator('size')
    def size_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('nano', 'micro', 'deca', 'hecto', 'kilo', 'mega', 'giga'):
            raise ValueError("must be one of enum values ('nano', 'micro', 'deca', 'hecto', 'kilo', 'mega', 'giga')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FlexBubble:
        """Create an instance of FlexBubble from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of styles
        if self.styles:
            _dict['styles'] = self.styles.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of header
        if self.header:
            _dict['header'] = self.header.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of hero
        if self.hero:
            _dict['hero'] = self.hero.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of footer
        if self.footer:
            _dict['footer'] = self.footer.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of action
        if self.action:
            _dict['action'] = self.action.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FlexBubble:
        """Create an instance of FlexBubble from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FlexBubble.parse_obj(obj)

        _obj = FlexBubble.parse_obj({
            "type": obj.get("type"),
            "direction": obj.get("direction"),
            "styles": FlexBubbleStyles.from_dict(obj.get("styles")) if obj.get("styles") is not None else None,
            "header": FlexBox.from_dict(obj.get("header")) if obj.get("header") is not None else None,
            "hero": FlexComponent.from_dict(obj.get("hero")) if obj.get("hero") is not None else None,
            "body": FlexBox.from_dict(obj.get("body")) if obj.get("body") is not None else None,
            "footer": FlexBox.from_dict(obj.get("footer")) if obj.get("footer") is not None else None,
            "size": obj.get("size"),
            "action": Action.from_dict(obj.get("action")) if obj.get("action") is not None else None
        })
        return _obj

