# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import StrictStr, validator
from linebot.v3.messaging.models.flex_component import FlexComponent

class FlexSpan(FlexComponent):
    """
    FlexSpan
    """
    text: Optional[StrictStr] = None
    size: Optional[StrictStr] = None
    color: Optional[StrictStr] = None
    weight: Optional[StrictStr] = None
    style: Optional[StrictStr] = None
    decoration: Optional[StrictStr] = None
    type: str = "span"

    __properties = ["type", "text", "size", "color", "weight", "style", "decoration"]

    @validator('weight')
    def weight_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('regular', 'bold'):
            raise ValueError("must be one of enum values ('regular', 'bold')")
        return value

    @validator('style')
    def style_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('normal', 'italic'):
            raise ValueError("must be one of enum values ('normal', 'italic')")
        return value

    @validator('decoration')
    def decoration_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('none', 'underline', 'line-through'):
            raise ValueError("must be one of enum values ('none', 'underline', 'line-through')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FlexSpan:
        """Create an instance of FlexSpan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FlexSpan:
        """Create an instance of FlexSpan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FlexSpan.parse_obj(obj)

        _obj = FlexSpan.parse_obj({
            "type": obj.get("type"),
            "text": obj.get("text"),
            "size": obj.get("size"),
            "color": obj.get("color"),
            "weight": obj.get("weight"),
            "style": obj.get("style"),
            "decoration": obj.get("decoration")
        })
        return _obj

