# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import Field, StrictBool, StrictInt, StrictStr, conlist, validator
from linebot.v3.messaging.models.action import Action
from linebot.v3.messaging.models.flex_component import FlexComponent
from linebot.v3.messaging.models.flex_span import FlexSpan

class FlexText(FlexComponent):
    """
    FlexText
    """
    flex: Optional[StrictInt] = None
    text: Optional[StrictStr] = None
    size: Optional[StrictStr] = None
    align: Optional[StrictStr] = None
    gravity: Optional[StrictStr] = None
    color: Optional[StrictStr] = None
    weight: Optional[StrictStr] = None
    style: Optional[StrictStr] = None
    decoration: Optional[StrictStr] = None
    wrap: Optional[StrictBool] = None
    line_spacing: Optional[StrictStr] = Field(None, alias="lineSpacing")
    margin: Optional[StrictStr] = None
    position: Optional[StrictStr] = None
    offset_top: Optional[StrictStr] = Field(None, alias="offsetTop")
    offset_bottom: Optional[StrictStr] = Field(None, alias="offsetBottom")
    offset_start: Optional[StrictStr] = Field(None, alias="offsetStart")
    offset_end: Optional[StrictStr] = Field(None, alias="offsetEnd")
    action: Optional[Action] = None
    max_lines: Optional[StrictInt] = Field(None, alias="maxLines")
    contents: Optional[conlist(FlexSpan)] = None
    adjust_mode: Optional[StrictStr] = Field(None, alias="adjustMode")
    scaling: Optional[StrictBool] = None
    type: str = "text"

    __properties = ["type", "flex", "text", "size", "align", "gravity", "color", "weight", "style", "decoration", "wrap", "lineSpacing", "margin", "position", "offsetTop", "offsetBottom", "offsetStart", "offsetEnd", "action", "maxLines", "contents", "adjustMode", "scaling"]

    @validator('align')
    def align_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('start', 'end', 'center'):
            raise ValueError("must be one of enum values ('start', 'end', 'center')")
        return value

    @validator('gravity')
    def gravity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('top', 'bottom', 'center'):
            raise ValueError("must be one of enum values ('top', 'bottom', 'center')")
        return value

    @validator('weight')
    def weight_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('regular', 'bold'):
            raise ValueError("must be one of enum values ('regular', 'bold')")
        return value

    @validator('style')
    def style_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('normal', 'italic'):
            raise ValueError("must be one of enum values ('normal', 'italic')")
        return value

    @validator('decoration')
    def decoration_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('none', 'underline', 'line-through'):
            raise ValueError("must be one of enum values ('none', 'underline', 'line-through')")
        return value

    @validator('position')
    def position_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('relative', 'absolute'):
            raise ValueError("must be one of enum values ('relative', 'absolute')")
        return value

    @validator('adjust_mode')
    def adjust_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('shrink-to-fit'):
            raise ValueError("must be one of enum values ('shrink-to-fit')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FlexText:
        """Create an instance of FlexText from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of action
        if self.action:
            _dict['action'] = self.action.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in contents (list)
        _items = []
        if self.contents:
            for _item in self.contents:
                if _item:
                    _items.append(_item.to_dict())
            _dict['contents'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FlexText:
        """Create an instance of FlexText from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FlexText.parse_obj(obj)

        _obj = FlexText.parse_obj({
            "type": obj.get("type"),
            "flex": obj.get("flex"),
            "text": obj.get("text"),
            "size": obj.get("size"),
            "align": obj.get("align"),
            "gravity": obj.get("gravity"),
            "color": obj.get("color"),
            "weight": obj.get("weight"),
            "style": obj.get("style"),
            "decoration": obj.get("decoration"),
            "wrap": obj.get("wrap"),
            "line_spacing": obj.get("lineSpacing"),
            "margin": obj.get("margin"),
            "position": obj.get("position"),
            "offset_top": obj.get("offsetTop"),
            "offset_bottom": obj.get("offsetBottom"),
            "offset_start": obj.get("offsetStart"),
            "offset_end": obj.get("offsetEnd"),
            "action": Action.from_dict(obj.get("action")) if obj.get("action") is not None else None,
            "max_lines": obj.get("maxLines"),
            "contents": [FlexSpan.from_dict(_item) for _item in obj.get("contents")] if obj.get("contents") is not None else None,
            "adjust_mode": obj.get("adjustMode"),
            "scaling": obj.get("scaling")
        })
        return _obj

