# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr

class GroupSummaryResponse(BaseModel):
    """
    GroupSummaryResponse
    https://developers.line.biz/en/reference/messaging-api/#get-group-summary
    """
    group_id: StrictStr = Field(..., alias="groupId", description="Group ID")
    group_name: StrictStr = Field(..., alias="groupName", description="Group name")
    picture_url: Optional[StrictStr] = Field(None, alias="pictureUrl", description="Group icon URL. Not included in the response if the user doesn't set a group profile icon.")

    __properties = ["groupId", "groupName", "pictureUrl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GroupSummaryResponse:
        """Create an instance of GroupSummaryResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GroupSummaryResponse:
        """Create an instance of GroupSummaryResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GroupSummaryResponse.parse_obj(obj)

        _obj = GroupSummaryResponse.parse_obj({
            "group_id": obj.get("groupId"),
            "group_name": obj.get("groupName"),
            "picture_url": obj.get("pictureUrl")
        })
        return _obj

