# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic.v1 import Field, conlist
from linebot.v3.messaging.models.image_carousel_column import ImageCarouselColumn
from linebot.v3.messaging.models.template import Template

class ImageCarouselTemplate(Template):
    """
    ImageCarouselTemplate
    """
    columns: conlist(ImageCarouselColumn) = Field(...)
    type: str = "image_carousel"

    __properties = ["type", "columns"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImageCarouselTemplate:
        """Create an instance of ImageCarouselTemplate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item in self.columns:
                if _item:
                    _items.append(_item.to_dict())
            _dict['columns'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImageCarouselTemplate:
        """Create an instance of ImageCarouselTemplate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ImageCarouselTemplate.parse_obj(obj)

        _obj = ImageCarouselTemplate.parse_obj({
            "type": obj.get("type"),
            "columns": [ImageCarouselColumn.from_dict(_item) for _item in obj.get("columns")] if obj.get("columns") is not None else None
        })
        return _obj

