# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist

class MembersIdsResponse(BaseModel):
    """
    MembersIdsResponse
    """
    member_ids: conlist(StrictStr, max_items=100) = Field(..., alias="memberIds", description="List of user IDs of members in the group chat. Only users of LINE for iOS and LINE for Android are included in `memberIds`.")
    next: Optional[StrictStr] = Field(None, description="A continuation token to get the next array of user IDs of the members in the group chat. Returned only when there are remaining user IDs that were not returned in `memberIds` in the original request. ")

    __properties = ["memberIds", "next"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MembersIdsResponse:
        """Create an instance of MembersIdsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MembersIdsResponse:
        """Create an instance of MembersIdsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MembersIdsResponse.parse_obj(obj)

        _obj = MembersIdsResponse.parse_obj({
            "member_ids": obj.get("memberIds"),
            "next": obj.get("next")
        })
        return _obj

